<?php
require 'conexao.php';

// Ativa debug de erros
ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id_oferta'] ?? '';
    
    // Dados Principais
    $produto = trim($_POST['produto']);
    $preco = $_POST['preco'];
    $medida = $_POST['medida'] ?? '';
    $formato = $_POST['formato'];
    $imagem_url = $_POST['imagem_url'];
    $logo_url = $_POST['logo_url'];
    $data_validade = empty($_POST['data_validade']) ? NULL : $_POST['data_validade'];
    $efeito_visual = $_POST['efeito_visual'] ?? 'normal';
    
    // Design
    $bg_tipo = $_POST['bg_tipo'] ?? 'padrao';
    $bg_valor = ($bg_tipo === 'cor') ? $_POST['bg_cor_input'] : $_POST['bg_img_input'];
    $extra_texto = $_POST['extra_texto'];
    $extra_cor = $_POST['extra_cor'];
    $extra_tamanho = $_POST['extra_tamanho'];
    $logo_tamanho = $_POST['logo_tamanho'];
    $template_style = $_POST['template_style'] ?? 'classico';
    
    // Posies
    $img_pos_x = $_POST['img_pos_x']; $img_pos_y = $_POST['img_pos_y'];
    $extra_pos_x = $_POST['extra_pos_x']; $extra_pos_y = $_POST['extra_pos_y'];
    $logo_pos_x = $_POST['logo_pos_x']; $logo_pos_y = $_POST['logo_pos_y'];

    // Tratamento Preo (Br para US)
    $precoFormatado = str_replace('.', '', $preco);
    $precoFormatado = str_replace(',', '.', $precoFormatado);
    if(!is_numeric($precoFormatado)) $precoFormatado = 0.00;

    try {
        // 1. SALVA NA TABELA DE OFERTAS (TV)
        if (!empty($id)) {
            $sql = "UPDATE ofertas SET 
                    produto=?, preco=?, medida=?, formato=?, imagem_url=?, logo_url=?, data_validade=?, efeito_visual=?,
                    bg_tipo=?, bg_valor=?, extra_texto=?, extra_cor=?, extra_tamanho=?, logo_tamanho=?,
                    img_pos_x=?, img_pos_y=?, extra_pos_x=?, extra_pos_y=?, logo_pos_x=?, logo_pos_y=?, template_style=?
                    WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $precoFormatado, $medida, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, 
                $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho,
                $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y, $template_style, $id
            ]);
            $msg = "Oferta ATUALIZADA com sucesso!";
        } else {
            $sql = "INSERT INTO ofertas 
                    (produto, preco, medida, formato, imagem_url, logo_url, data_validade, efeito_visual, bg_tipo, bg_valor, extra_texto, extra_cor, extra_tamanho, logo_tamanho, img_pos_x, img_pos_y, extra_pos_x, extra_pos_y, logo_pos_x, logo_pos_y, template_style) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $precoFormatado, $medida, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho, $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y, $template_style
            ]);
            $msg = "Oferta CRIADA com sucesso!";
        }

        // 2. SALVA NO HISTRICO (AGORA COM IMAGEM)
        if (!empty($produto)) {
            // Sintaxe compatvel com qualquer MySQL: Se existir, atualiza preo E imagem
            $sqlHist = "INSERT INTO produtos_salvos (nome, preco, imagem_url) VALUES (?, ?, ?)
                        ON DUPLICATE KEY UPDATE preco = VALUES(preco), imagem_url = VALUES(imagem_url)";
            $stmtHist = $pdo->prepare($sqlHist);
            $stmtHist->execute([$produto, $precoFormatado, $imagem_url]);
        }

        echo $msg;

    } catch (PDOException $e) {
        echo "ERRO PDO: " . $e->getMessage();
    }
}
?>