<?php
require 'conexao.php';
header('Content-Type: application/json');

$termo = $_GET['term'] ?? '';

if (strlen($termo) < 2) {
    echo json_encode([]);
    exit;
}

try {
    // Busca Nome e Preço
    $sql = "SELECT nome, preco FROM produtos_salvos WHERE nome LIKE ? ORDER BY nome ASC LIMIT 10";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(["%$termo%"]);
    
    // Retorna um array de objetos: [{nome: 'Coca', preco: '5.00'}, ...]
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
} catch (PDOException $e) {
    echo json_encode([]);
}
?>