<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>TV Pro - Estável</title>
    <meta http-equiv="refresh" content="3600"> <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900&family=Oswald:wght@700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    <style>
        /* RESET */
        * { box-sizing: border-box; }
        body { 
            margin: 0; overflow: hidden; background: #000; 
            width: 100vw; height: 100vh; 
            font-family: 'Montserrat', sans-serif; cursor: none; 
        }
        
        #app {
            position: absolute; top: 50%; left: 50%;
            width: 1920px; height: 1080px; 
            background: radial-gradient(circle at center, #ffffff 0%, #dcdcdc 100%);
            background-color: #ffffff;
            box-shadow: 0 0 100px rgba(0,0,0,0.8);
            opacity: 0; transition: opacity 0.5s ease;
            overflow: hidden; display: flex;
        }

        .sidebar { z-index: 2; display: flex; flex-direction: column; justify-content: center; padding: 50px; height: 100%; transition: 0.3s; }
        .visual { position: relative; overflow: hidden; height: 100%; display: flex; align-items: center; justify-content: center; isolation: isolate; }

        .layout-landscape { flex-direction: row; width: 1920px; height: 1080px; }
        .layout-landscape .sidebar { width: 40%; align-items: flex-start; text-align: left; }
        .layout-landscape .visual { width: 60%; }

        .layout-portrait { flex-direction: column-reverse; width: 1080px; height: 1920px; }
        .layout-portrait .sidebar { width: 100%; height: 40%; align-items: center; text-align: center; padding-top: 20px; }
        .layout-portrait .visual { width: 100%; height: 60%; }

        /* TEXTOS */
        .title-box { width: 100%; height: 300px; display: flex; align-items: center; overflow: hidden; margin-bottom: 20px; }
        .price-box { width: 100%; height: 250px; display: flex; align-items: center; overflow: hidden; }
        .layout-portrait .title-box, .layout-portrait .price-box { justify-content: center; }

        .prod-title { line-height: 1.1; margin: 0; width: 100%; font-size: 90px; text-shadow: 2px 2px 4px rgba(0,0,0,0.2); }
        .prod-price { font-weight: 900; line-height: 1; white-space: nowrap; font-size: 160px; }
        .tag-oferta { display: inline-block; padding: 15px 40px; border-radius: 8px; font-weight: bold; margin-bottom: 20px; text-transform: uppercase; font-size: 30px; letter-spacing: 2px; white-space: nowrap; }

        .img-container { width: 100%; height: 100%; position: relative; }
        .img-produto { 
            position: absolute; max-width: 90%; max-height: 90%; 
            object-fit: contain; 
            filter: drop-shadow(0 20px 40px rgba(0,0,0,0.4)); 
            transition: 0.5s;
            top: 50%; left: 50%; transform: translate(-50%, -50%);
            backface-visibility: hidden; 
        }

        .modo-multiply { mix-blend-mode: multiply; }
        .logo-area { position: absolute; display: flex; align-items: center; justify-content: center; z-index: 10; }
        .extra-text { position: absolute; font-weight: bold; white-space: nowrap; z-index: 5; text-shadow: 3px 3px 6px rgba(0,0,0,0.5); }

        /* TEMPLATES (Mantidos iguais) */
        .tpl-classico .sidebar { background: linear-gradient(135deg, #d32f2f 0%, #b71c1c 100%); color: white; clip-path: polygon(0 0, 100% 0, 92% 100%, 0% 100%); }
        .layout-portrait.tpl-classico .sidebar { clip-path: polygon(0 10%, 100% 0, 100% 100%, 0% 100%); }
        .tpl-classico .tag-oferta { background: #ffeb3b; color: #d32f2f; }
        .tpl-classico .prod-title { font-family: 'Montserrat', sans-serif; font-weight: 900; text-transform: uppercase; }
        .tpl-classico .prod-price { background: rgba(0,0,0,0.2); padding: 10px 40px; border-radius: 20px; }

        .tpl-premium { background-color: #1a1a1a !important; background: none !important; }
        .tpl-premium .sidebar { background: #111; color: #d4af37; border-right: 10px solid #d4af37; }
        .layout-portrait.tpl-premium .sidebar { border-right: none; border-top: 10px solid #d4af37; }
        .tpl-premium .tag-oferta { background: #d4af37; color: #000; letter-spacing: 5px; }
        .tpl-premium .prod-title { font-family: 'Playfair Display', serif; font-style: italic; }
        .tpl-premium .prod-price { color: #fff; text-shadow: 0 0 30px #d4af37; }
        .tpl-premium .modo-multiply { mix-blend-mode: normal !important; }

        .tpl-fresh .sidebar { background: linear-gradient(to bottom, #4caf50, #2e7d32); color: white; border-radius: 0 100px 100px 0; margin-right: -60px; z-index: 5; }
        .layout-portrait.tpl-fresh .sidebar { border-radius: 100px 100px 0 0; margin-right: 0; margin-top: -60px; }
        .tpl-fresh .tag-oferta { background: white; color: #2e7d32; border-radius: 50px; }
        .tpl-fresh .prod-title { font-family: 'Montserrat', sans-serif; font-weight: 700; }
        .tpl-fresh .prod-price { color: #a5d6a7; }

        .tpl-impacto .sidebar { background: #ffeb3b; color: #d32f2f; }
        .tpl-impacto .tag-oferta { background: #d32f2f; color: #fff; transform: skew(-10deg); }
        .tpl-impacto .prod-title { font-family: 'Oswald', sans-serif; line-height: 0.9; text-transform: uppercase; transform: skew(-5deg); color: #d32f2f; }
        .tpl-impacto .prod-price { color: #000; font-weight: 900; letter-spacing: -5px; }
    </style>
</head>
<body>

<div id="loading" style="color:white; font-size:30px; position:absolute; z-index:999; top:50%; left:50%; transform:translate(-50%, -50%);">Iniciando...</div>

<div id="app">
    <div id="sidebar" class="sidebar">
        <div class="tag-oferta">OFERTA ESPECIAL</div>
        <div class="title-box"><h1 class="prod-title" id="elProduto">...</h1></div>
        <div class="price-box"><div class="prod-price" id="elPreco">...</div></div>
        <div id="elValidade" style="font-size:30px; margin-top:30px; opacity:0.8; font-weight:bold;"></div>
    </div>
    <div class="visual">
        <div class="img-container">
            <div id="elLogo" class="logo-area" style="display:none"><img style="width:100%; height:100%; object-fit:contain"></div>
            <img id="elImg" class="img-produto" src="">
            <div id="elExtra" class="extra-text" style="display:none"></div>
        </div>
    </div>
</div>

<script>
    // CONFIGURAÇÕES GERAIS
    const CONFIG = { 
        tempoSlide: 12000, // 12 Segundos (Aumentei um pouco para leitura)
        modo: "<?php echo $_GET['modo'] ?? 'landscape'; ?>",
        tempoAtualizacao: 30000 // Busca novas ofertas a cada 30s em background
    };
    
    const app = document.getElementById('app'); 
    
    // VARIÁVEIS DE CONTROLE
    let playlistAtual = []; // O que está passando agora
    let novaPlaylist = []; // O que veio do banco (fila de espera)
    let index = 0;
    let timerLoop; // Controle do timer para não duplicar

    // --- ZOOM ---
    function ajustarTela() {
        const baseW = CONFIG.modo === 'landscape' ? 1920 : 1080;
        const baseH = CONFIG.modo === 'landscape' ? 1080 : 1920;
        const scale = Math.min(window.innerWidth / baseW, window.innerHeight / baseH);
        app.style.width = baseW + "px"; app.style.height = baseH + "px";
        app.style.transform = `translate(-50%, -50%) scale(${scale})`;
    }
    window.addEventListener('resize', ajustarTela); ajustarTela();

    // --- AUTO TEXT SIZE ---
    function ajustarTamanhoTexto(elemento, max, min, container) {
        let size = max; elemento.style.fontSize = size + "px";
        while ( (elemento.scrollHeight > container.clientHeight || elemento.scrollWidth > container.clientWidth) && size > min ) {
            size -= 5; elemento.style.fontSize = size + "px";
        }
    }

    // --- 1. CARREGAR DADOS EM BACKGROUND (Sem parar o slide) ---
    async function buscarAtualizacoes() {
        try {
            const r = await fetch(`api.php?modo=${CONFIG.modo}&t=${Date.now()}`);
            const dados = await r.json();
            if(dados.length > 0) {
                novaPlaylist = dados; // Salva na variavel temporaria
                // Se for a primeira vez, inicia tudo
                if(playlistAtual.length === 0) {
                    playlistAtual = novaPlaylist;
                    document.getElementById('loading').style.display = 'none';
                    ajustarTela();
                    iniciarPlayer();
                }
            }
        } catch(e) { console.error("Erro ao buscar:", e); }
    }

    // --- 2. LOOP PRINCIPAL ---
    function iniciarPlayer() {
        if(timerLoop) clearTimeout(timerLoop); // Limpa timers anteriores
        proximoSlide();
    }

    function proximoSlide() {
        app.style.opacity = 0; // Fade Out

        setTimeout(() => {
            // VERIFICA SE DEVE REINICIAR OU TROCAR DE LISTA
            if(index >= playlistAtual.length) {
                index = 0;
                // Se tem atualizações do banco, troca a fita agora
                if(novaPlaylist.length > 0) {
                    playlistAtual = novaPlaylist;
                }
            }

            const item = playlistAtual[index];
            montarSlide(item);

        }, 600); // Tempo do fade out
    }

    function montarSlide(item) {
        const tpl = item.template_style || 'classico';
        
        // APLICAR DADOS
        app.className = `layout-${CONFIG.modo} tpl-${tpl}`;
        
        const elProd = document.getElementById('elProduto'); 
        const elPreco = document.getElementById('elPreco');
        elProd.innerText = item.produto; 
        elPreco.innerText = "R$ " + parseFloat(item.preco).toFixed(2).replace('.',',');
        
        elProd.style.fontSize = (tpl==='impacto'?'110px':'90px'); 
        elPreco.style.fontSize = (tpl==='impacto'?'200px':'160px');

        // PREPARA IMAGEM
        const img = document.getElementById('elImg');
        
        // Remove listener antigo para evitar disparos duplos
        img.onload = null; 
        
        img.src = item.imagem_url;

        // Estilos da Imagem
        if(item.efeito_visual === 'multiply' && tpl !== 'premium') img.classList.add('modo-multiply'); else img.classList.remove('modo-multiply');
        if(item.img_pos_x && item.img_pos_x !== 'center') { img.style.left = item.img_pos_x; img.style.top = item.img_pos_y; img.style.transform = 'none'; } 
        else { img.style.left = '50%'; img.style.top = '50%'; img.style.transform = 'translate(-50%, -50%)'; }

        // Extras (Logo, Fundo, Texto, Validade)
        const logoDiv = document.getElementById('elLogo');
        if(item.logo_url) { logoDiv.querySelector('img').src = item.logo_url; logoDiv.style.display = 'flex'; const size = (item.logo_tamanho || 100) * 1.5; logoDiv.style.width = size+'px'; logoDiv.style.height = size+'px'; if(item.logo_pos_x && item.logo_pos_x !== 'default') { logoDiv.style.left=item.logo_pos_x; logoDiv.style.top=item.logo_pos_y; logoDiv.style.right='auto'; } else { logoDiv.style.top='60px'; logoDiv.style.right='60px'; logoDiv.style.left=''; } } else { logoDiv.style.display='none'; }
        
        const extDiv = document.getElementById('elExtra');
        if(item.extra_texto) { extDiv.innerText = item.extra_texto; extDiv.style.color = item.extra_cor; extDiv.style.fontSize = (item.extra_tamanho * 2) + 'px'; extDiv.style.display = 'block'; if(item.extra_pos_x && item.extra_pos_x !== 'center') { extDiv.style.left=item.extra_pos_x; extDiv.style.top=item.extra_pos_y; } else { extDiv.style.left='50%'; extDiv.style.top='85%'; } } else { extDiv.style.display='none'; }

        app.style.background = '';
        if(item.bg_tipo === 'padrao') { app.style.background = ''; app.style.backgroundColor = ''; }
        else if(item.bg_tipo === 'cor') { app.style.background = item.bg_valor; }
        else if(item.bg_tipo === 'imagem') { app.style.background = `url('${item.bg_valor}') center/cover`; }

        const valDiv = document.getElementById('elValidade');
        if(item.data_validade && item.data_validade !== '0000-00-00') { const d = item.data_validade.split('-'); valDiv.innerText=`Oferta válida até ${d[2]}/${d[1]}`; } else { valDiv.innerText=""; }

        // --- SISTEMA DE EXIBIÇÃO SEGURO ---
        // Se a imagem já estiver cacheada, mostra logo. Se não, espera carregar.
        if (img.complete) {
            finalizarExibicao();
        } else {
            img.onload = function() {
                finalizarExibicao();
            };
            // Fallback: Se a imagem demorar +3 segundos, mostra sem imagem mesmo
            setTimeout(() => { if(app.style.opacity == 0) finalizarExibicao(); }, 3000);
        }
    }

    function finalizarExibicao() {
        const item = playlistAtual[index]; // Pega item atual de novo por segurança
        const tpl = item.template_style || 'classico';
        const elProd = document.getElementById('elProduto'); 
        const elPreco = document.getElementById('elPreco');

        app.style.opacity = 1; // Fade In

        // Ajusta texto após renderizar
        setTimeout(() => {
            ajustarTamanhoTexto(elProd, (tpl==='impacto'?120:90), 40, document.querySelector('.title-box'));
            ajustarTamanhoTexto(elPreco, (tpl==='impacto'?220:160), 80, document.querySelector('.price-box'));
        }, 50);

        // Prepara próximo passo
        index++;
        
        // Agenda o próximo slide com segurança (limpa anterior)
        if(timerLoop) clearTimeout(timerLoop);
        timerLoop = setTimeout(proximoSlide, CONFIG.tempoSlide);
    }

    // --- INICIALIZAÇÃO ---
    // 1. Inicia busca periódica
    setInterval(buscarAtualizacoes, CONFIG.tempoAtualizacao);
    // 2. Busca primeira vez
    buscarAtualizacoes();

</script>
</body>
</html>