<?php
require 'conexao.php';
header('Content-Type: application/json');

$termo = $_GET['term'] ?? ''; // O script do index envia ?term=...

if (strlen($termo) < 2) {
    echo json_encode([]);
    exit;
}

try {
    // Busca na tabela DEFINITIVA de produtos
    $sql = "SELECT nome FROM produtos_salvos WHERE nome LIKE ? ORDER BY nome ASC LIMIT 10";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(["%$termo%"]);
    
    // Retorna apenas a coluna 'nome'
    echo json_encode($stmt->fetchAll(PDO::FETCH_COLUMN));
} catch (PDOException $e) {
    echo json_encode([]);
}
?>