<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* twittermetro-designer-javascript.twig */
class __TwigTemplate_26c7837fbd0bb4ed6f42102d52c656b57076dc16a0a3eeb08eea532e1be62c34 extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 9
        echo "
<script type=\"text/javascript\">

    // Runs after form opens
    function twittermetro_form_edit_open() {
        
        // Set duration field, using the helper ()
        formHelpers.setupCheckboxInputFields(\$(this).find('form'), '#useDuration', '.duration-fields');

        // Set override template field, using the helper ()
        formHelpers.setupCheckboxInputFields(\$(this).find('form'), '#overrideColorTemplate', '.template-override-controls', '.template-selector-control');

        // Set effect type input field, using the helper ()
        formHelpers.setupObjectValueInputFields(\$(this).find('form'), '#effect', ['.effect-controls'], ['noAnim'], true);

        // Configure colours form
        const dialog = \$(this);

        configureColoursForm(dialog, dialog.data().extra);
        
        // Register an onchange listener to do the same if the template is changed
        \$(this).find('#colorTemplateId').on('change', function() {
            configureColoursForm(dialog, dialog.data().extra);
        });

        // Turn the background colour into a picker
        \$(this).find('#backgroundColor').colorpicker();

        // Tidy up colorpickers on modal close
        if(dialog.hasClass('modal')) {
            dialog.on(\"hide.bs.modal\", function(e) {
                if(e.namespace === 'bs.modal') {
                    // Remove colour pickers
                    dialog.find(\".colorpicker-element\").colorpicker('destroy');
                }
            });
        }
    }

    function configureColoursForm(dialog, extra) {

        // Get template
        var twittermetroColorsTemplate = formHelpers.getTemplate('twittermetroColorsTemplate');

        var chosenColors = extra.colors;
        var availableTemplates = extra.templates;

        // Get the empty div field and check if exists
        var templateColorsFields = \$(dialog).find('#templateColors');
        if(templateColorsFields.length == 0)
            return;

        // Reset all the fields and the click event  
        templateColorsFields.unbind('click');
        templateColorsFields.empty();

        var colorsUsed;
        if(chosenColors != null && chosenColors.length > 0 && \$(dialog).find('#overrideColorTemplate').is(':checked')) {
            colorsUsed = chosenColors.split('|');
        } else {
            // Get the current template selected
            var templateColoursId = \$(dialog).find('#colorTemplateId').val();

            // Get the current template id and fill the text field with its colour values
            for(var i = 0;i < availableTemplates.length;i++) {
                if(availableTemplates[i].id == templateColoursId) {
                    colorsUsed = availableTemplates[i].colors;
                }
            }
        }

        var colorTitle = '";
        // line 80
        echo __("Colour");
        echo "';

        if(colorsUsed == null || colorsUsed.length == 0) {
            // Add a empty row
            var itemTitle = colorTitle + ' ' + 1;
            var context = {value: '', title: itemTitle, colorId: 'color1', buttonGlyph: 'fa-plus'};
            templateColorsFields.append(twittermetroColorsTemplate(context));

            // Transform to a color picker field
            \$('#color1').colorpicker();
        } else {

            for(var i = 0;i < colorsUsed.length;i++) {
                var itemTitle = colorTitle + ' ' + (i + 1);
                var colorId = 'color' + i;
                var context = {value: colorsUsed[i], title: itemTitle, colorId: colorId, buttonGlyph: ((i == (colorsUsed.length - 1)) ? 'fa-plus' : 'fa-minus')};

                templateColorsFields.append(twittermetroColorsTemplate(context));

                // Transform to a color picker field
                \$(dialog).find('#' + colorId).colorpicker();
                \$(dialog).find('#' + colorId).css('background-color', colorsUsed[i]);
            }
        }

        // Create an event to add/remove color input fields
        templateColorsFields.on('click', 'button', function(e) {
            e.preventDefault();

            // find the glyph
            if(\$(this).find('i').hasClass('fa-plus')) {
                // Add a empty row
                var itemTitle = colorTitle + ' ' + (templateColorsFields.find('.form-group').length + 1);
                var colorId = 'color' + templateColorsFields.find('.form-group').length;
                var context = {value: '', title: itemTitle, colorId: colorId, buttonGlyph: 'fa-plus'};

                // Change the clicked button to a minus button
                \$(this).find('i').addClass('fa-minus')
                \$(this).find('i').removeClass('fa-plus')

                templateColorsFields.append(twittermetroColorsTemplate(context));

                // Transform to a color picker field
                \$(dialog).find('#' + colorId).colorpicker();

                // Create an event for the new button
                \$(dialog).find('#' + colorId).focusout(function(e) {
                    e.preventDefault();
                    \$(this).css('background-color', \$(this).val());
                });
            } else if(\$(this).find('i').hasClass('fa-minus')) {
                // Remove this row
                \$(this).closest('.form-group').remove();
            }
        });

        // Create an event to add/remove color input fields
        templateColorsFields.find('input').focusout(function(e) {
            e.preventDefault();
            \$(this).css('background-color', \$(this).val());
        });
    };

</script>";
    }

    public function getTemplateName()
    {
        return "twittermetro-designer-javascript.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  103 => 80,  30 => 9,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("", "twittermetro-designer-javascript.twig", "/home/mgatv524/public_html/serraazul/modules/twittermetro-designer-javascript.twig");
    }
}
