<?php
session_start();
require 'config.php';
require 'auth.php';

// Filtros Iniciais
$profissional_id = $_GET['profissional_id'] ?? '';
$inicio = $_GET['inicio'] ?? date('Y-m-01'); // Início do mês atual
$fim    = $_GET['fim']    ?? date('Y-m-t');  // Fim do mês atual

$resultados = [];
$profissional_nome = "";

// Lista para o Select
$listaProfissionais = $pdo->query("SELECT * FROM profissionais ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);

// Se tiver selecionado alguém, busca os plantões
if ($profissional_id) {
    // Pega nome do profissional
    foreach($listaProfissionais as $p) {
        if($p['id'] == $profissional_id) $profissional_nome = $p['nome'];
    }

    $sql = "SELECT pl.*, s.nome as nome_sala 
            FROM plantoes pl 
            JOIN salas s ON pl.sala_id = s.id 
            WHERE pl.profissional_id = ? 
            AND pl.data_plantao BETWEEN ? AND ?
            ORDER BY pl.data_plantao ASC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$profissional_id, $inicio, $fim]);
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <title>Consulta Individual</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f4f6f9; font-family: 'Segoe UI', sans-serif; }
        .card-header { background-color: #fff; border-bottom: 1px solid #eee; }
        
        /* Badges de Turno */
        .turno-dia { background-color: #fff3e0; color: #e65100; border: 1px solid #ffe0b2; padding: 5px 10px; border-radius: 20px; font-weight: bold; font-size: 0.85rem; }
        .turno-noite { background-color: #e8eaf6; color: #1a237e; border: 1px solid #c5cae9; padding: 5px 10px; border-radius: 20px; font-weight: bold; font-size: 0.85rem; }

        @media print {
            .no-print { display: none !important; }
            body { background: white; }
            .card { border: none; shadow: none; }
            .print-header { display: block !important; border-bottom: 2px solid #000; margin-bottom: 20px; }
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="print-header text-center mb-4" style="display:none;">
        <h3>EXTRATO DE PLANTÕES</h3>
        <p><strong>Profissional:</strong> <?php echo $profissional_nome; ?><br>
        <strong>Período:</strong> <?php echo date('d/m/Y', strtotime($inicio)); ?> a <?php echo date('d/m/Y', strtotime($fim)); ?></p>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4 no-print">
        <h3 class="text-primary fw-bold"><i class="fa fa-search"></i> Consulta Individual</h3>
        <a href="index.php" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> Voltar</a>
    </div>

    <div class="card shadow-sm mb-4 no-print">
        <div class="card-body">
            <form method="GET" class="row g-3 align-items-end">
                <div class="col-md-5">
                    <label class="form-label fw-bold small text-muted">Profissional</label>
                    <select name="profissional_id" class="form-select" required>
                        <option value="">Selecione...</option>
                        <?php foreach($listaProfissionais as $p): ?>
                            <option value="<?php echo $p['id']; ?>" <?php echo ($profissional_id == $p['id']) ? 'selected' : ''; ?>>
                                <?php echo $p['nome']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold small text-muted">De</label>
                    <input type="date" name="inicio" class="form-control" value="<?php echo $inicio; ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold small text-muted">Até</label>
                    <input type="date" name="fim" class="form-control" value="<?php echo $fim; ?>">
                </div>
                <div class="col-md-1">
                    <button type="submit" class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                </div>
            </form>
        </div>
    </div>

    <?php if ($profissional_id && empty($resultados)): ?>
        <div class="alert alert-info text-center">Nenhum plantão encontrado para este período.</div>
    <?php elseif (!empty($resultados)): ?>
        <div class="card shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold text-dark">
                    <i class="fa fa-user-md text-primary"></i> <?php echo $profissional_nome; ?>
                </span>
                <button onclick="window.print()" class="btn btn-sm btn-success no-print"><i class="fa fa-print"></i> Imprimir</button>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Data</th>
                            <th>Dia da Semana</th>
                            <th>Turno</th>
                            <th>Sala / Setor</th>
                            <th class="text-center">Turma</th>
                            <th class="text-center">Carga Horária</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $totalHoras = 0;
                        $diasSemana = ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'];
                        
                        foreach($resultados as $r): 
                            $diaSemana = $diasSemana[date('w', strtotime($r['data_plantao']))];
                            $horas = 12; // Padrão 12h, ou pegue do banco se tiver coluna 'horas'
                            $totalHoras += $horas;
                            
                            $classeTurno = ($r['turno'] == 'dia') ? 'turno-dia' : 'turno-noite';
                            $iconeTurno  = ($r['turno'] == 'dia') ? 'fa-sun' : 'fa-moon';
                        ?>
                        <tr>
                            <td class="fw-bold"><?php echo date('d/m/Y', strtotime($r['data_plantao'])); ?></td>
                            <td class="text-muted"><?php echo $diaSemana; ?></td>
                            <td>
                                <span class="<?php echo $classeTurno; ?>">
                                    <i class="fa <?php echo $iconeTurno; ?>"></i> <?php echo ucfirst($r['turno']); ?>
                                </span>
                            </td>
                            <td><?php echo $r['nome_sala']; ?></td>
                            <td class="text-center fw-bold"><?php echo $r['turma']; ?></td>
                            <td class="text-center text-secondary"><?php echo $horas; ?>h</td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot class="table-secondary">
                        <tr>
                            <td colspan="5" class="text-end fw-bold">TOTAL DE HORAS NO PERÍODO:</td>
                            <td class="text-center fw-bold text-primary fs-5"><?php echo $totalHoras; ?>h</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>

</body>
</html>