<?php
// --- 1. SEGURANÇA E CONFIGURAÇÃO ---
require 'config.php';
require 'auth.php'; 

// --- 2. CONFIGURAÇÕES INICIAIS ---
$turmas = ['A', 'B', 'C', 'D'];

// Filtro de Turmas
$filtroTurmas = $_GET['filtro_turmas'] ?? $turmas;
if (!is_array($filtroTurmas)) { $filtroTurmas = $turmas; }
$queryStringFiltro = http_build_query(['filtro_turmas' => $filtroTurmas]);

// Navegação de Datas
$dataInicio = $_GET['data'] ?? date('Y-m-d');
$diaAnterior = date('Y-m-d', strtotime('-1 day', strtotime($dataInicio)));
$diaProximo  = date('Y-m-d', strtotime('+1 day', strtotime($dataInicio)));

// Gera os 7 dias
$datasExibidas = [];
$diasSemanaNome = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];
for ($i = 0; $i < 7; $i++) {
    $datasExibidas[] = date('Y-m-d', strtotime("+$i days", strtotime($dataInicio)));
}

// --- 3. POST (Salvar/Excluir/Trocar) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? '';
    $redirectData = $_POST['view_date'] ?? date('Y-m-d');
    $redirectFiltro = $_POST['filtro_atual'] ?? ''; 

    if ($acao === 'solicitar_troca') {
        if ($_POST['profissional_original'] != $_POST['substituto_id']) {
            $stmt = $pdo->prepare("INSERT INTO trocas (plantao_id, substituto_id, solicitante_id, motivo) VALUES (?, ?, ?, ?)");
            $stmt->execute([$_POST['id'], $_POST['substituto_id'], $_SESSION['usuario_id'], 'Solicitação via Painel']);
        }
        header("Location: trocas.php"); exit;
    }

    if (isAdmin()) {
        if ($acao === 'salvar') {
            $dados = [$_POST['profissional_id'], $_POST['turma'], $_POST['turno'], $_POST['id'] ?? ''];
            if ($_POST['id']) {
                $pdo->prepare("UPDATE plantoes SET profissional_id=?, turma=?, turno=? WHERE id=?")->execute($dados);
            } else {
                $pdo->prepare("INSERT INTO plantoes (sala_id, data_plantao, profissional_id, turma, turno) VALUES (?, ?, ?, ?, ?)")
                    ->execute([$_POST['sala_id'], $_POST['data_plantao'], $_POST['profissional_id'], $_POST['turma'], $_POST['turno']]);
            }
        } elseif ($acao === 'excluir') {
            $pdo->prepare("DELETE FROM plantoes WHERE id=?")->execute([$_POST['id']]);
        }
    }
    header("Location: index.php?data=$redirectData&$redirectFiltro"); exit;
}

// --- 4. BUSCA DADOS ---
$salas = $pdo->query("SELECT * FROM salas ORDER BY ordem ASC")->fetchAll(PDO::FETCH_ASSOC);
$listaProfissionais = $pdo->query("SELECT * FROM profissionais ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);

$turmasIn = "'" . implode("','", $filtroTurmas) . "'";
$sql = "SELECT pl.*, pr.nome as nome_profissional 
        FROM plantoes pl 
        JOIN profissionais pr ON pl.profissional_id = pr.id 
        WHERE (data_plantao BETWEEN ? AND ?) AND pl.turma IN ($turmasIn)";
$stmt = $pdo->prepare($sql);
$stmt->execute([$datasExibidas[0], end($datasExibidas)]);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

$escala = [];
foreach ($registros as $reg) { $escala[$reg['sala_id']][$reg['data_plantao']][] = $reg; }
?>

<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escala Hospitalar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* TELA NORMAL */
        body { background-color: #f4f6f9; font-family: 'Segoe UI', sans-serif; overflow: hidden; }
        .header-area { padding: 8px 15px; background: #ffffff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .main-container { padding: 10px; height: calc(100vh - 85px); }
        .table-responsive { height: 100%; background: #ffffff; border-radius: 10px; border: 1px solid #e0e0e0; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
        .table > :not(caption) > * > * { border-width: 1px; border-color: #ebebeb; }
        th, td { vertical-align: middle; text-align: center; padding: 0.5rem; color: #333; }
        thead th { position: sticky; top: 0; z-index: 10; background-color: #0d6efd; color: white; border-bottom: 2px solid #0a58ca; font-weight: 600; }
        .col-sala { position: sticky; left: 0; z-index: 5; background-color: #f8f9fa !important; border-right: 2px solid #dee2e6 !important; width: 140px; font-weight: bold; color: #495057; }
        .th-hoje { background-color: #fd7e14 !important; color: white !important; border-bottom: 3px solid white; }
        
        .badge-plantao { display: block; width: 100%; text-align: left; padding: 6px 8px; margin-bottom: 4px; cursor: pointer; border: 1px solid #bbdefb; border-radius: 6px; font-size: 0.85rem; font-weight: 500; transition: 0.2s; }
        .badge-plantao:hover { transform: translateY(-1px); }
        .badge-turma { float: right; font-weight: bold; background: #0d6efd; color: white; border-radius: 4px; padding: 0 6px; font-size: 0.75rem; }
        .plantao-dia { background-color: #fff3e0; color: #e65100; border-color: #ffe0b2; }
        .plantao-noite { background-color: #e8eaf6; color: #1a237e; border-color: #c5cae9; }
        
        .status-bar { display: flex; align-items: center; gap: 15px; padding: 5px 15px; border-radius: 8px; font-weight: bold; transition: 0.5s; border: 1px solid rgba(0,0,0,0.1); min-width: 200px; justify-content: space-between; }
        .turno-dia { background: linear-gradient(90deg, #fff3e0 0%, #ffe0b2 100%); color: #e65100; border-color: #ffcc80; }
        .turno-noite { background: linear-gradient(90deg, #1a237e 0%, #283593 100%); color: #fff; border-color: #3949ab; }
        .relogio-grande { font-size: 1.3rem; letter-spacing: 1px; font-family: 'Courier New', monospace; font-weight: 800; }
        .turno-label { font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.5px; opacity: 0.9; }
        .legenda-turmas { font-size: 0.75rem; color: #6c757d; margin-left: 15px; border-left: 1px solid #dee2e6; padding-left: 15px; line-height: 1.2; }
        .btn-add { width: 100%; border: 1px dashed #ced4da; color: #adb5bd; font-size: 0.8rem; padding: 4px; margin-top: 2px; border-radius: 4px; }
        .btn-add:hover { background: #f8f9fa; color: #0d6efd; border-color: #0d6efd; }

        /* --- CORREÇÃO DE IMPRESSÃO --- */
        @media print {
            @page { size: landscape; margin: 5mm; }
            html, body { height: auto !important; overflow: visible !important; background: white !important; color: black !important; }
            .header-area, .no-print, .btn-add, .modal, ::-webkit-scrollbar { display: none !important; }
            .print-header { display: block !important; border-bottom: 2px solid #000; margin-bottom: 10px; padding-bottom: 5px; }
            .main-container, .table-responsive { height: auto !important; overflow: visible !important; border: none !important; display: block !important; margin: 0 !important; padding: 0 !important; }
            table { width: 100% !important; border-collapse: collapse !important; }
            th, td { border: 1px solid #000 !important; color: #000 !important; background: white !important; padding: 4px !important; font-size: 10pt !important; }
            thead th { position: static !important; background-color: #eee !important; color: black !important; }
            .col-sala { position: static !important; width: 100px !important; background: #f0f0f0 !important; -webkit-print-color-adjust: exact; }
            .badge-plantao { background: none !important; color: black !important; border: none !important; border-bottom: 1px solid #ccc !important; margin: 0 !important; padding: 2px 0 !important; box-shadow: none !important; }
            .badge-plantao i { color: #000 !important; opacity: 1 !important; }
            .badge-turma { border: 1px solid #000 !important; background-color: #fff !important; color: #000 !important; }
        }
    </style>
</head>
<body>

<div class="print-header text-center" style="display:none;">
    <h3 class="m-0 fw-bold">ESCALA DE PLANTÃO</h3>
    <p class="m-0 small"><strong>Período:</strong> <?php echo date('d/m/Y', strtotime($datasExibidas[0])); ?> a <?php echo date('d/m/Y', strtotime(end($datasExibidas))); ?> | <strong>Turmas:</strong> <?php echo implode(', ', $filtroTurmas); ?></p>
</div>

<div class="header-area d-flex justify-content-between align-items-center no-print">
    <div class="d-flex align-items-center gap-2">
        <div id="boxTurno" class="status-bar turno-dia shadow-sm">
            <div class="text-start" style="line-height:1.1">
                <div id="relogio" class="relogio-grande">00:00:00</div>
                <div id="textoTurno" class="turno-label">Carregando...</div>
            </div>
            <i id="iconeTurno" class="fa fa-sun fa-2x"></i>
        </div>
        <div class="d-none d-xxl-block legenda-turmas"><strong>Escala 12h:</strong><br>2 Dias (07h-19h) <i class="fa fa-arrow-right text-muted"></i> 2 Noites (19h-07h)</div>
        <div class="btn-group btn-group-sm shadow-sm ms-3">
            <a href="?data=<?php echo $diaAnterior; ?>&<?php echo $queryStringFiltro; ?>" class="btn btn-outline-secondary"><i class="fa fa-chevron-left"></i></a>
            <button type="button" class="btn btn-white border border-secondary px-3 text-dark fw-bold" onclick="document.getElementById('pickerData').showPicker()">
               <i class="fa fa-calendar-alt text-primary"></i> <?php echo date('d/m', strtotime($dataInicio)); ?>
            </button>
            <a href="?data=<?php echo $diaProximo; ?>&<?php echo $queryStringFiltro; ?>" class="btn btn-outline-secondary"><i class="fa fa-chevron-right"></i></a>
        </div>
        <input type="date" id="pickerData" style="visibility:hidden; position:absolute;" onchange="alterarData(this.value)">
    </div>

    <form id="formFiltro" method="GET" class="d-flex align-items-center bg-light rounded px-2 py-1 border d-none d-xl-flex">
        <input type="hidden" name="data" value="<?php echo $dataInicio; ?>">
        <span class="small text-muted me-2 fw-bold">TURMAS:</span>
        <?php foreach($turmas as $t): ?>
            <?php $checked = in_array($t, $filtroTurmas) ? 'checked' : ''; ?>
            <input type="checkbox" class="btn-check" name="filtro_turmas[]" id="btn-check-<?php echo $t; ?>" value="<?php echo $t; ?>" <?php echo $checked; ?> onchange="document.getElementById('formFiltro').submit()">
            <label class="btn btn-sm btn-outline-secondary py-0 px-2 fw-bold me-1" for="btn-check-<?php echo $t; ?>"><?php echo $t; ?></label>
        <?php endforeach; ?>
    </form>

    <div class="d-flex gap-2 align-items-center">
        <span class="badge bg-secondary me-1 d-none d-lg-inline-block" title="Usuário Logado"><i class="fa fa-user"></i> <?php echo substr($_SESSION['usuario_nome'] ?? 'User', 0, 10); ?></span>
        <?php if(isAdmin()): ?>
            <a href="salas.php" class="btn btn-sm btn-outline-secondary" title="Salas"><i class="fa fa-door-open"></i></a>
            <a href="profissionais.php" class="btn btn-sm btn-outline-secondary" title="Equipe"><i class="fa fa-user-md"></i></a>
        <?php endif; ?>
        
        <a href="consulta_profissional.php" class="btn btn-sm btn-outline-info" title="Consultar Extrato Individual"><i class="fa fa-search"></i></a>

        <a href="trocas.php" class="btn btn-sm btn-outline-warning text-dark" title="Trocas"><i class="fa fa-exchange-alt"></i></a>
        <a href="relatorios.php" class="btn btn-sm btn-outline-primary" title="Relatórios"><i class="fa fa-chart-pie"></i></a>
        <button onclick="window.print()" class="btn btn-sm btn-success shadow-sm" title="Imprimir PDF"><i class="fa fa-file-pdf"></i></button>
        <a href="logout.php" class="btn btn-sm btn-danger ms-2 shadow-sm"><i class="fa fa-power-off"></i></a>
    </div>
</div>

<div class="main-container">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th class="col-sala">SALA</th>
                    <?php foreach ($datasExibidas as $data): ?>
                        <th class="<?php echo ($data == date('Y-m-d')) ? 'th-hoje' : ''; ?>">
                            <?php echo date('d/m', strtotime($data)); ?> <br class="no-print">
                            <small class="opacity-75" style="font-weight:normal"><?php echo $diasSemanaNome[date('w', strtotime($data))]; ?></small>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($salas as $sala): ?>
                <tr>
                    <td class="col-sala" style="border-left: 5px solid <?php echo $sala['cor_borda']; ?> !important;">
                        <?php echo $sala['nome']; ?>
                    </td>
                    <?php foreach ($datasExibidas as $data): ?>
                    <td>
                        <?php if (isset($escala[$sala['id']][$data])): ?>
                            <?php foreach ($escala[$sala['id']][$data] as $plantao): 
                                // LINHA CORRIGIDA ABAIXO
                                $classeTurno = ($plantao['turno'] ?? 'dia') == 'dia' ? 'plantao-dia' : 'plantao-noite';
                                $icone = ($plantao['turno'] ?? 'dia') == 'dia' ? 'fa-sun' : 'fa-moon';
                            ?>
                                <div class="badge-plantao <?php echo $classeTurno; ?>" onclick="editar(<?php echo htmlspecialchars(json_encode($plantao)); ?>)">
                                    <span class="badge-turma"><?php echo $plantao['turma']; ?></span>
                                    <i class="fa <?php echo $icone; ?> small opacity-50 me-1"></i>
                                    <?php echo substr($plantao['nome_profissional'], 0, 15); ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <?php if(isAdmin()): ?>
                            <button class="btn btn-add no-print" onclick="novo(<?php echo $sala['id']; ?>, '<?php echo $data; ?>')"><i class="fa fa-plus"></i></button>
                        <?php endif; ?>
                    </td>
                    <?php endforeach; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalPlantao" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content">
            <form method="POST" id="formModal">
                <div class="modal-header py-2">
                    <h6 class="modal-title" id="modalTitulo">Gerenciar Escala</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="plantaoId">
                    <input type="hidden" name="acao" id="inputAcao" value="salvar">
                    <input type="hidden" name="view_date" value="<?php echo $dataInicio; ?>">
                    <input type="hidden" name="filtro_atual" value="<?php echo $queryStringFiltro; ?>">
                    <input type="hidden" name="sala_id" id="inputSalaId">
                    <input type="hidden" name="data_plantao" id="inputData">
                    <input type="hidden" name="substituto_id" id="inputSubstitutoId">
                    <input type="hidden" name="profissional_original" id="inputProfissionalOriginal">

                    <div class="mb-2 bg-light p-2 rounded border">
                        <label class="small text-muted mb-1 d-block fw-bold">Horário (Turno):</label>
                        <div class="btn-group btn-group-sm w-100" role="group">
                            <input type="radio" class="btn-check" name="turno" id="turno_dia" value="dia" checked onchange="recalcularTurma()">
                            <label class="btn btn-outline-warning text-dark" for="turno_dia"><i class="fa fa-sun"></i> 07h-19h</label>
                            
                            <input type="radio" class="btn-check" name="turno" id="turno_noite" value="noite" onchange="recalcularTurma()">
                            <label class="btn btn-outline-dark" for="turno_noite"><i class="fa fa-moon"></i> 19h-07h</label>
                        </div>
                    </div>

                    <div class="mb-2">
                        <div class="d-flex justify-content-between">
                            <label class="small text-muted mb-1">Filtrar Médicos:</label>
                            <small class="text-primary fw-bold" id="sugestaoTurma" style="font-size:0.75rem"></small>
                        </div>
                        <div class="btn-group btn-group-sm w-100" role="group">
                            <input type="radio" class="btn-check" name="modal_filtro" id="m_filtro_todos" value="todos" onchange="filtrarProfissionais('todos')">
                            <label class="btn btn-outline-secondary px-1" for="m_filtro_todos">Todos</label>
                            <?php foreach($turmas as $t): ?>
                                <input type="radio" class="btn-check" name="modal_filtro" id="m_filtro_<?php echo $t; ?>" value="<?php echo $t; ?>" onchange="filtrarProfissionais('<?php echo $t; ?>')">
                                <label class="btn btn-outline-secondary px-1" for="m_filtro_<?php echo $t; ?>"><?php echo $t; ?></label>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="mb-2">
                        <label class="small text-muted" id="labelProfissional">Profissional</label>
                        <select name="profissional_id" id="inputProfissional" class="form-select form-select-sm" required>
                            <option value="">Selecione...</option>
                        </select>
                    </div>

                    <?php if(isAdmin()): ?>
                        <div class="mb-3">
                            <label class="small text-muted">Turma Registrada</label>
                            <select name="turma" id="inputTurma" class="form-select form-select-sm bg-light">
                                <?php foreach($turmas as $t): echo "<option value='$t'>$t</option>"; endforeach; ?>
                            </select>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="turma" id="inputTurma"> 
                    <?php endif; ?>
                    
                    <div class="d-flex justify-content-between mt-3">
                        <?php if(isAdmin()): ?>
                            <button type="button" class="btn btn-sm btn-outline-danger" id="btnExcluir" style="display:none;" onclick="excluir()"><i class="fa fa-trash"></i></button>
                            <button type="submit" class="btn btn-sm btn-primary w-50 ms-auto">Salvar</button>
                        <?php else: ?>
                            <div id="divSolicitarTroca" style="display:none; width:100%;">
                                <button type="button" onclick="solicitarTroca()" class="btn btn-sm btn-warning w-100 fw-bold">Trocar</button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </form>
            <form id="formExcluir" method="POST" style="display:none;"> 
                <input type="hidden" name="acao" value="excluir"> 
                <input type="hidden" name="id" id="idExcluir"> 
                <input type="hidden" name="view_date" value="<?php echo $dataInicio; ?>">
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    const modal = new bootstrap.Modal(document.getElementById('modalPlantao'));
    const todosProfissionais = <?php echo json_encode($listaProfissionais); ?>;
    
    // Marco Zero do Ciclo 2x2
    const DATA_REF = new Date('2025-01-01T00:00:00'); 

    function alterarData(novaData) {
        const params = new URLSearchParams(window.location.search);
        params.set('data', novaData);
        window.location.search = params.toString();
    }

    function atualizarRelogio() {
        const agora = new Date();
        document.getElementById('relogio').innerText = agora.toLocaleTimeString('pt-BR');
        const hora = agora.getHours();
        const box = document.getElementById('boxTurno');
        const icon = document.getElementById('iconeTurno');
        const texto = document.getElementById('textoTurno');
        if (hora >= 7 && hora < 19) {
            box.className = 'status-bar turno-dia shadow-sm';
            icon.className = 'fa fa-sun fa-2x';
            texto.innerText = 'TURNO DIA (07h-19h)';
        } else {
            box.className = 'status-bar turno-noite shadow-sm';
            icon.className = 'fa fa-moon fa-2x';
            texto.innerText = 'TURNO NOITE (19h-07h)';
        }
    }
    setInterval(atualizarRelogio, 1000);
    atualizarRelogio();

    function calcularTurmaAutomatica(dataStr, turno) {
        const dataAlvo = new Date(dataStr + 'T00:00:00');
        const diffTime = Math.abs(dataAlvo - DATA_REF);
        const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24)); 
        const ciclo = diffDays % 4;
        let grupo = (ciclo == 0 || ciclo == 1) ? 1 : 2;
        if (turno === 'dia') return (grupo === 1) ? 'A' : 'B';
        else return (grupo === 1) ? 'C' : 'D';
    }

    function recalcularTurma() {
        const data = document.getElementById('inputData').value;
        if(!data) return;
        
        const turno = document.querySelector('input[name="turno"]:checked').value;
        const turmaCalculada = calcularTurmaAutomatica(data, turno);
        
        document.getElementById('sugestaoTurma').innerText = 'Sugestão: Turma ' + turmaCalculada;
        filtrarProfissionais(turmaCalculada);
        if(document.getElementById('inputTurma')) {
            document.getElementById('inputTurma').value = turmaCalculada;
        }
    }

    function filtrarProfissionais(filtro = 'todos', selecionado = null) {
        const select = document.getElementById('inputProfissional');
        select.innerHTML = '<option value="">Selecione...</option>';
        todosProfissionais.forEach(prof => {
            if (filtro === 'todos' || prof.turma_preferencial === filtro) {
                const option = document.createElement('option');
                option.value = prof.id;
                option.text = prof.nome;
                if (selecionado && prof.id == selecionado) option.selected = true;
                select.appendChild(option);
            }
        });
        const radio = document.getElementById('m_filtro_' + filtro);
        if(radio) radio.checked = true;
    }

    document.getElementById('inputProfissional').addEventListener('change', function() {
        const selectedId = this.value;
        const prof = todosProfissionais.find(p => p.id == selectedId);
        if(prof && document.getElementById('inputTurma')) {
            document.getElementById('inputTurma').value = prof.turma_preferencial;
        }
    });

    function novo(salaId, data) {
        document.getElementById('plantaoId').value = ''; 
        document.getElementById('inputAcao').value = 'salvar';
        document.getElementById('inputSalaId').value = salaId; 
        document.getElementById('inputData').value = data; 
        document.getElementById('modalTitulo').innerText = 'Adicionar Plantão';
        if(document.getElementById('btnExcluir')) document.getElementById('btnExcluir').style.display = 'none';
        document.getElementById('turno_dia').checked = true;
        recalcularTurma();
        modal.show();
    }
    
    function editar(plantao) {
        document.getElementById('plantaoId').value = plantao.id;
        document.getElementById('inputSalaId').value = plantao.sala_id; 
        document.getElementById('inputData').value = plantao.data_plantao;
        document.getElementById('inputProfissionalOriginal').value = plantao.profissional_id; 
        
        if(plantao.turno === 'noite') document.getElementById('turno_noite').checked = true;
        else document.getElementById('turno_dia').checked = true;

        filtrarProfissionais('todos', plantao.profissional_id);
        
        if(document.getElementById('inputTurma')) document.getElementById('inputTurma').value = plantao.turma;

        <?php if(isAdmin()): ?>
            document.getElementById('inputAcao').value = 'salvar';
            document.getElementById('modalTitulo').innerText = 'Editar Plantão';
            document.getElementById('btnExcluir').style.display = 'block';
        <?php else: ?>
            document.getElementById('modalTitulo').innerText = 'Solicitar Troca';
            document.getElementById('divSolicitarTroca').style.display = 'block';
            document.getElementById('labelProfissional').innerText = 'Substituto';
            document.getElementById('helpTroca').style.display = 'block';
        <?php endif; ?>

        modal.show();
    }
    
    function solicitarTroca() {
        const original = document.getElementById('inputProfissionalOriginal').value;
        const substituto = document.getElementById('inputProfissional').value;
        if(!substituto || original == substituto) { alert('Selecione um substituto diferente.'); return; }
        if(confirm('Confirmar troca?')) {
            document.getElementById('inputAcao').value = 'solicitar_troca';
            document.getElementById('inputSubstitutoId').value = substituto;
            document.getElementById('formModal').submit();
        }
    }

    function excluir() { 
        if(confirm('Confirmar exclusão?')) { 
            document.getElementById('idExcluir').value = document.getElementById('plantaoId').value; 
            document.getElementById('formExcluir').submit(); 
        } 
    }
</script>
</body>
</html>