<?php
// Inicia sessão se não estiver iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require 'config.php';

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $senha = $_POST['senha'];

    // Busca o usuário no banco
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    // Verifica a senha
    if ($user && password_verify($senha, $user['senha'])) {
        // --- SALVA DADOS NA SESSÃO (CRUCIAL PARA O SISTEMA) ---
        $_SESSION['usuario_id'] = $user['id'];
        $_SESSION['usuario_email'] = $user['email'];
        
        // Se o campo 'nome' estiver vazio no banco, usa 'Usuário' como padrão
        $_SESSION['usuario_nome'] = $user['nome'] ?? 'Usuário'; 
        
        // Se o campo 'nivel' estiver vazio, define como 'visualizador' por segurança
        $_SESSION['usuario_nivel'] = $user['nivel'] ?? 'visualizador';

        // Redireciona para o painel
        header("Location: index.php");
        exit;
    } else {
        $erro = "E-mail ou senha incorretos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acesso - Escala Hospitalar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* Estilo Hospital Clean */
        body { 
            /* Gradiente Azul Suave e Profissional */
            background: linear-gradient(135deg, #e3f2fd 0%, #90caf9 100%); 
            height: 100vh; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            font-family: 'Segoe UI', sans-serif;
        }
        
        .card-login { 
            width: 100%; 
            max-width: 400px; 
            padding: 40px; 
            border-radius: 15px; 
            background-color: white; 
            border: none; 
            box-shadow: 0 15px 35px rgba(0,0,0,0.1); 
        }

        .btn-primary {
            background-color: #0d6efd;
            border: none;
            padding: 10px;
            font-weight: 600;
            transition: 0.3s;
        }
        .btn-primary:hover {
            background-color: #0b5ed7;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
        }

        .form-control {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 10px;
        }
        .form-control:focus {
            background-color: #fff;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.15);
        }
        
        .logo-icon {
            font-size: 3rem;
            color: #0d6efd;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

    <div class="card card-login">
        <div class="text-center mb-4">
            <div class="logo-icon"><i class="fa fa-hospital-user"></i></div>
            <h3 class="text-primary fw-bold mb-1">Portal da Escala</h3>
            <p class="text-muted small">Acesso Restrito</p>
        </div>
        
        <?php if($erro): ?>
            <div class="alert alert-danger py-2 text-center border-0 shadow-sm">
                <i class="fa fa-exclamation-circle"></i> <?php echo $erro; ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3">
                <label class="form-label fw-bold text-secondary small">E-mail</label>
                <div class="input-group">
                    <span class="input-group-text bg-light border-end-0"><i class="fa fa-envelope text-muted"></i></span>
                    <input type="email" name="email" class="form-control border-start-0 ps-0" placeholder="usuario@hospital.com" required autofocus>
                </div>
            </div>
            
            <div class="mb-4">
                <label class="form-label fw-bold text-secondary small">Senha</label>
                <div class="input-group">
                    <span class="input-group-text bg-light border-end-0"><i class="fa fa-lock text-muted"></i></span>
                    <input type="password" name="senha" class="form-control border-start-0 ps-0" placeholder="••••••" required>
                </div>
            </div>
            
            <button type="submit" class="btn btn-primary w-100 mb-3">
                Entrar no Sistema <i class="fa fa-arrow-right ms-2"></i>
            </button>
            
            <div class="text-center">
                <small class="text-muted">Esqueceu a senha? Contate o TI.</small>
            </div>
        </form>
    </div>

</body>
</html>