<?php
// profissionais.php
session_start();
require 'config.php';
require 'auth.php'; // Segurança

// CRUD
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? '';
    
    if ($acao === 'salvar') {
        $id = $_POST['id'] ?? '';
        $nome = $_POST['nome'];
        $cargo = $_POST['cargo'];
        $turma = $_POST['turma'];

        if ($id) {
            // ATUALIZAR
            $stmt = $pdo->prepare("UPDATE profissionais SET nome=?, cargo=?, turma_preferencial=? WHERE id=?");
            $stmt->execute([$nome, $cargo, $turma, $id]);
        } else {
            // INSERIR
            $stmt = $pdo->prepare("INSERT INTO profissionais (nome, cargo, turma_preferencial) VALUES (?, ?, ?)");
            $stmt->execute([$nome, $cargo, $turma]);
        }
    } elseif ($acao === 'excluir') {
        // Verifica se tem plantões antes de excluir (opcional, mas seguro)
        $stmt = $pdo->prepare("DELETE FROM profissionais WHERE id=?");
        $stmt->execute([$_POST['id']]);
    }
    header("Location: profissionais.php"); exit;
}

$equipe = $pdo->query("SELECT * FROM profissionais ORDER BY turma_preferencial, nome")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Equipe</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style> body { background-color: #f4f6f9; } </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between mb-4">
        <h3><i class="fa fa-users"></i> Gestão da Equipe</h3>
        <a href="index.php" class="btn btn-secondary">Voltar</a>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm mb-3 border-0">
                <div class="card-header bg-white fw-bold" id="cardTitulo">Novo Profissional</div>
                <div class="card-body">
                    <form method="POST" id="formProfissional">
                        <input type="hidden" name="acao" value="salvar">
                        <input type="hidden" name="id" id="inputId"> <div class="mb-3">
                            <label>Nome Completo</label>
                            <input type="text" name="nome" id="inputNome" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Cargo</label>
                            <input type="text" name="cargo" id="inputCargo" class="form-control" placeholder="Ex: Médico">
                        </div>
                        <div class="mb-3">
                            <label>Turma Padrão</label>
                            <select name="turma" id="inputTurma" class="form-select">
                                <option value="A">Turma A</option>
                                <option value="B">Turma B</option>
                                <option value="C">Turma C</option>
                                <option value="D">Turma D</option>
                            </select>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success" id="btnSalvar">Cadastrar</button>
                            <button type="button" class="btn btn-outline-secondary" id="btnCancelar" style="display:none;" onclick="limparForm()">Cancelar Edição</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card shadow-sm border-0">
                <div class="card-body p-0">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light"><tr><th>Turma</th><th>Nome</th><th>Cargo</th><th class="text-end">Ação</th></tr></thead>
                        <tbody>
                            <?php foreach($equipe as $p): ?>
                            <tr>
                                <td><span class="badge bg-primary rounded-circle" style="width:25px; height:25px; display:flex; align-items:center; justify-content:center;"><?php echo $p['turma_preferencial']; ?></span></td>
                                <td class="fw-bold"><?php echo $p['nome']; ?></td>
                                <td class="text-muted small"><?php echo $p['cargo']; ?></td>
                                <td class="text-end">
                                    <button class="btn btn-sm btn-outline-primary border-0 me-1" 
                                            onclick="editar(<?php echo htmlspecialchars(json_encode($p)); ?>)">
                                        <i class="fa fa-pen"></i>
                                    </button>

                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Tem certeza que deseja excluir?');">
                                        <input type="hidden" name="acao" value="excluir">
                                        <input type="hidden" name="id" value="<?php echo $p['id']; ?>">
                                        <button class="btn btn-sm btn-outline-danger border-0"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function editar(prof) {
        // Preenche o formulário com os dados do profissional clicado
        document.getElementById('inputId').value = prof.id;
        document.getElementById('inputNome').value = prof.nome;
        document.getElementById('inputCargo').value = prof.cargo;
        document.getElementById('inputTurma').value = prof.turma_preferencial;
        
        // Muda o visual para "Modo Edição"
        document.getElementById('cardTitulo').innerText = 'Editar Profissional';
        document.getElementById('btnSalvar').innerText = 'Salvar Alterações';
        document.getElementById('btnSalvar').classList.replace('btn-success', 'btn-primary');
        document.getElementById('btnCancelar').style.display = 'block';
    }

    function limparForm() {
        document.getElementById('formProfissional').reset();
        document.getElementById('inputId').value = '';
        
        // Volta para "Modo Cadastro"
        document.getElementById('cardTitulo').innerText = 'Novo Profissional';
        document.getElementById('btnSalvar').innerText = 'Cadastrar';
        document.getElementById('btnSalvar').classList.replace('btn-primary', 'btn-success');
        document.getElementById('btnCancelar').style.display = 'none';
    }
</script>
</body>
</html>