<?php
require 'config.php';
require 'auth.php'; // Segurança

// Filtro de Datas (Padrão: Mês atual)
$inicio = $_GET['inicio'] ?? date('Y-m-01');
$fim    = $_GET['fim']    ?? date('Y-m-t');

// Query Poderosa: Conta plantões e soma horas por médico
$sql = "SELECT pr.nome, pr.cargo, 
        COUNT(pl.id) as total_plantoes, 
        SUM(pl.horas) as total_horas 
        FROM profissionais pr
        LEFT JOIN plantoes pl ON pr.id = pl.profissional_id 
        AND pl.data_plantao BETWEEN ? AND ?
        GROUP BY pr.id 
        HAVING total_plantoes > 0
        ORDER BY total_horas DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute([$inicio, $fim]);
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <title>Relatório de Horas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f4f6f9; font-family: 'Segoe UI', sans-serif; }
        .relatorio-header { background: #fff; padding: 20px; border-bottom: 1px solid #ddd; }
        @media print {
            .no-print { display: none !important; }
            body { background: white; }
            .card { border: none !important; shadow: none !important; }
        }
    </style>
</head>
<body>

<div class="relatorio-header d-flex justify-content-between align-items-center">
    <div>
        <h3 class="fw-bold text-primary"><i class="fa fa-chart-pie"></i> Relatório de Horas</h3>
        <p class="text-muted m-0">Período: <?php echo date('d/m/Y', strtotime($inicio)); ?> a <?php echo date('d/m/Y', strtotime($fim)); ?></p>
    </div>
    <div class="no-print d-flex gap-2">
        <form class="d-flex gap-2 align-items-center">
            <input type="date" name="inicio" class="form-control" value="<?php echo $inicio; ?>">
            <input type="date" name="fim" class="form-control" value="<?php echo $fim; ?>">
            <button type="submit" class="btn btn-primary"><i class="fa fa-filter"></i> Filtrar</button>
        </form>
        <button onclick="window.print()" class="btn btn-success"><i class="fa fa-file-pdf"></i> Imprimir</button>
        <a href="index.php" class="btn btn-outline-secondary">Voltar</a>
    </div>
</div>

<div class="container mt-4">
    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <table class="table table-striped table-hover mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>Profissional</th>
                        <th>Cargo</th>
                        <th class="text-center">Qtd. Plantões</th>
                        <th class="text-center">Total Horas</th>
                        <th class="text-end">Valor Estimado*</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $geralHoras = 0;
                    foreach($dados as $d): 
                        $geralHoras += $d['total_horas'];
                    ?>
                    <tr>
                        <td class="fw-bold"><?php echo $d['nome']; ?></td>
                        <td><span class="badge bg-secondary"><?php echo $d['cargo']; ?></span></td>
                        <td class="text-center"><?php echo $d['total_plantoes']; ?></td>
                        <td class="text-center fw-bold text-primary"><?php echo $d['total_horas']; ?>h</td>
                        <td class="text-end text-muted">R$ -</td> </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot class="table-light">
                    <tr>
                        <th colspan="3" class="text-end">TOTAL GERAL:</th>
                        <th class="text-center"><?php echo $geralHoras; ?>h</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <p class="text-muted small mt-3">* O cálculo de horas baseia-se na duração cadastrada no plantão (Padrão: 12h).</p>
</div>
</body>
</html>