<?php
// reset_senha.php
require 'config.php';

$email = 'admin@hospital.com';
$senha_clara = '123456';

// 1. Gera o hash da senha corretamente usando o algoritmo do seu servidor
$nova_senha_hash = password_hash($senha_clara, PASSWORD_DEFAULT);

try {
    // 2. Remove o usuário antigo se existir (para evitar duplicidade)
    $stmtDelete = $pdo->prepare("DELETE FROM usuarios WHERE email = ?");
    $stmtDelete->execute([$email]);

    // 3. Insere o usuário novo com a senha correta
    $stmtInsert = $pdo->prepare("INSERT INTO usuarios (email, senha) VALUES (?, ?)");
    $stmtInsert->execute([$email, $nova_senha_hash]);

    echo "<h3>Sucesso!</h3>";
    echo "<p>Usuário recriado/resetado.</p>";
    echo "<ul>";
    echo "<li><strong>Email:</strong> $email</li>";
    echo "<li><strong>Senha:</strong> $senha_clara</li>";
    echo "</ul>";
    echo "<br><a href='login.php'>Clique aqui para Logar</a>";

} catch (PDOException $e) {
    echo "Erro no banco de dados: " . $e->getMessage();
}
?>