<?php
session_start();
if (!isset($_SESSION['usuario_id'])) { header("Location: login.php"); exit; }
require 'config.php';

// CRUD
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? '';
    if ($acao === 'salvar') {
        $stmt = $pdo->prepare("INSERT INTO salas (nome, cor_borda, ordem) VALUES (?, ?, ?)");
        $stmt->execute([$_POST['nome'], $_POST['cor'], $_POST['ordem']]);
    } elseif ($acao === 'excluir') {
        $stmt = $pdo->prepare("DELETE FROM salas WHERE id=?");
        $stmt->execute([$_POST['id']]);
    }
    header("Location: salas.php"); exit;
}
$salas = $pdo->query("SELECT * FROM salas ORDER BY ordem ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Salas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
</head>
<body>
<div class="container mt-4">
    <div class="d-flex justify-content-between mb-4 align-items-center">
        <h4 class="m-0"><i class="fa fa-door-open"></i> Configuração de Salas</h4>
        <a href="index.php" class="btn btn-sm btn-outline-light"><i class="fa fa-arrow-left"></i> Voltar</a>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm mb-3">
                <div class="card-header py-2">Nova Sala</div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="acao" value="salvar">
                        <div class="mb-2">
                            <label class="small">Nome da Sala</label>
                            <input type="text" name="nome" class="form-control form-control-sm" required placeholder="Ex: Raio-X">
                        </div>
                        <div class="row mb-3">
                            <div class="col-6">
                                <label class="small">Cor da Borda</label>
                                <input type="color" name="cor" class="form-control form-control-color w-100" value="#ffffff">
                            </div>
                            <div class="col-6">
                                <label class="small">Ordem</label>
                                <input type="number" name="ordem" class="form-control form-control-sm" value="99">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-sm btn-success w-100">Adicionar</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body p-0 table-responsive">
                    <table class="table table-hover table-sm mb-0 align-middle">
                        <thead class="table-dark"><tr><th>Ordem</th><th style="width:50px">Cor</th><th>Nome</th><th class="text-end">Ação</th></tr></thead>
                        <tbody>
                            <?php foreach($salas as $s): ?>
                            <tr>
                                <td><?php echo $s['ordem']; ?></td>
                                <td><div style="width:20px; height:20px; background-color:<?php echo $s['cor_borda']; ?>; border-radius:50%; border:1px solid #555;"></div></td>
                                <td><?php echo $s['nome']; ?></td>
                                <td class="text-end">
                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Excluir esta sala apagará toda a escala vinculada a ela. Continuar?');">
                                        <input type="hidden" name="acao" value="excluir">
                                        <input type="hidden" name="id" value="<?php echo $s['id']; ?>">
                                        <button class="btn btn-sm btn-outline-danger border-0"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>