<?php
// 1. Configurações de Cabeçalho (Essencial para o Xibo aceitar os dados)
header("Access-Control-Allow-Origin: *"); // Permite acesso de qualquer IP/Player
header("Content-Type: application/json; charset=UTF-8"); // Diz que é um JSON
header("Cache-Control: no-cache, no-store, must-revalidate"); // Evita cache antigo

// 2. Configurações do Banco de Dados
// ATENÇÃO: Preencha com os dados reais do seu servidor (cPanel/Hostgator/etc)
$host = 'localhost';
$dbname = 'mgacom_ofertas'; // Nome do seu banco de dados
$username = 'mgacom_ofertas'; // Seu usuário do banco
$password = 'Xs.0FUg-JwyI'; // Sua senha

try {
    // Conexão via PDO (Mais seguro)
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 3. A Query SQL
    // Seleciona apenas as ofertas ativas (se tiver coluna 'ativo') ou todas
    // Ordena por 'destaque' primeiro, para os itens importantes aparecerem no topo
    $sql = "SELECT 
                produto, 
                preco, 
                unidade, 
                imagem, 
                destaque 
            FROM ofertas 
            ORDER BY destaque DESC, id DESC"; 

    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // 4. Busca todos os resultados de uma vez
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 5. Retorna o JSON limpo para o Xibo
    // Se não tiver nada, retorna array vazio []
    echo json_encode($resultados, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    // Em caso de erro, retorna um JSON de erro para você ver no navegador
    http_response_code(500);
    echo json_encode(["erro" => "Erro de conexão: " . $e->getMessage()]);
}
?>