<?php
// --- 1. CONFIGURAES DE PERFORMANCE (CACHE ZERO) ---
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
// Estas linhas obrigam o navegador a NO guardar cpia velha
header("Cache-Control: no-cache, no-store, must-revalidate"); 
header("Pragma: no-cache");
header("Expires: 0");

require 'config.php';

try {
    // Pega o ID do usurio (padro 1 se no vier)
    $uid = isset($_GET['uid']) ? (int)$_GET['uid'] : 1;

    // --- 2. DESCOBRIR A URL REAL DO SITE ---
    $protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    // Pega a pasta onde este arquivo est (ex: /painel/)
    $caminho = dirname($_SERVER['PHP_SELF']);
    // Garante que termina com barra
    $baseUrl = $protocolo . "://" . $host . $caminho . "/";
    // Correo para barras duplas se houver
    $baseUrl = str_replace('//', '/', $baseUrl); 
    $baseUrl = str_replace($protocolo . ':/', $protocolo . '://', $baseUrl);

    // Busca os produtos
    $sql = "SELECT id, produto, preco, unidade, imagem, categoria, destaque, filial_id 
            FROM ofertas 
            WHERE ativo = 1 AND usuario_id = :uid
            ORDER BY id DESC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':uid' => $uid]);
    $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // --- 3. CORRIGIR OS LINKS DAS IMAGENS ---
    foreach ($dados as $key => $item) {
        $img = $item['imagem'];
        
        // Se no tem imagem, define vazio (o JS vai por o placeholder)
        if (empty($img)) {
            $dados[$key]['imagem'] = ""; 
        } 
        // Se j  um link completo da internet (http...), mantm
        elseif (strpos($img, 'http') === 0) {
            $dados[$key]['imagem'] = $img;
        } 
        // Se  um arquivo local (uploads/...), adiciona o domnio na frente
        else {
            $dados[$key]['imagem'] = $baseUrl . $img;
        }
    }

    echo json_encode($dados);

} catch (PDOException $e) {
    echo json_encode([]);
}
?>