<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Encarte 1-4-1 (Multi-Usuário)</title>
<link href="https://fonts.googleapis.com/css2?family=Oswald:wght@700&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    /* RESET */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background-color: #e0e0e0; 
        font-family: 'Montserrat', sans-serif;
        overflow: hidden;
    }

    /* --- TOPO --- */
    #topo {
        width: 100%; height: 15vh; 
        background: linear-gradient(to right, #b71c1c, #d32f2f, #b71c1c);
        border-bottom: 0.8vh solid #ffc107;
        text-align: center;
        position: absolute; top: 0; left: 0; z-index: 100;
        box-shadow: 0 1vh 3vh rgba(0,0,0,0.4);
        display: flex; align-items: center; justify-content: center;
    }
    #topo h1 {
        font-family: 'Montserrat', sans-serif;
        font-weight: 900;
        font-size: 8vh; 
        color: #ffc107; 
        text-transform: uppercase; margin: 0;
        letter-spacing: 0.5vw;
        text-shadow: 0.3vh 0.3vh 1vh rgba(0,0,0,0.5);
    }

    /* --- ÁREA PRINCIPAL --- */
    #main-container {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 1vh 1vw;
        display: flex; 
    }

    .col-lateral { width: 25%; height: 100%; padding: 1vh; }
    .col-central { width: 50%; height: 100%; padding: 0.5vh; }

    /* --- CARD LATERAL --- */
    .card-lateral {
        width: 100%; height: 98%;
        background: linear-gradient(135deg, #c62828 0%, #b71c1c 100%);
        border-radius: 3vh;
        box-shadow: 0 2vh 4vh rgba(0,0,0,0.4);
        border: 0.3vh solid rgba(255,255,255,0.2);
        position: relative;
        display: flex; flex-direction: column; 
        justify-content: space-between; overflow: hidden;
        animation: fadeIn 0.5s ease;
    }
    
    .lat-tag {
        position: absolute; top: 2vh; right: -1vw; 
        background: #ffc107; color: #b71c1c;
        padding: 0.5vh 2vw; font-weight: 900; font-size: 2.5vh;
        box-shadow: 0.3vh 0.3vh 1vh rgba(0,0,0,0.3);
        transform: rotate(5deg); z-index: 20;
    }

    .lat-img {
        width: 100%; flex-grow: 1; 
        display: flex; align-items: center; justify-content: center;
        padding: 1vh; z-index: 10; min-height: 0;
    }
    .lat-img img { 
        max-height: 100%; max-width: 95%; 
        object-fit: contain; filter: drop-shadow(0 3vh 3vh rgba(0,0,0,0.5));
    }
    
    .lat-nome {
        width: 100%; flex-shrink: 0;
        text-align: center; color: white; font-weight: 900; 
        font-size: 3.5vh; padding: 0 1vw 1vh 1vw; 
        line-height: 1.1; text-transform: uppercase;
        text-shadow: 0.2vh 0.2vh 0.5vh rgba(0,0,0,0.3); z-index: 20;
    }
    .lat-nome span { display: block; }

    .lat-footer {
        width: 100%; height: 25%; display: flex; align-items: center; justify-content: center;
        padding-bottom: 2vh; flex-shrink: 0;
    }

    .lat-preco-box {
        width: 85%; height: 100%;
        background: rgba(255,255,255,0.1);
        border: 0.3vh solid rgba(255,255,255,0.5);
        border-radius: 2vh;
        display: flex; align-items: center; justify-content: center; color: #fff;
    }
    
    .lat-rs { font-size: 3vh; font-weight: bold; margin-top: -3vh; margin-right: 0.5vw; color: #ffc107; }
    .lat-valor { 
        font-family: 'Oswald', sans-serif; font-size: 11vh; 
        font-weight: 700; letter-spacing: -0.3vh; line-height: 1;
        text-shadow: 0.4vh 0.4vh 0 rgba(0,0,0,0.2);
    }
    .lat-un { font-size: 2vh; font-weight: 700; color: #ffc107; align-self: flex-end; margin-bottom: 2vh; margin-left: 0.5vw;}


    /* --- CARD CENTRAL --- */
    .card-central {
        width: 48%; height: 48%; float: left; margin: 1%;
        background: linear-gradient(to bottom, #fff59d, #ffeb3b);
        border-radius: 2vh; box-shadow: 0 1vh 2vh rgba(0,0,0,0.15);
        border: 0.3vh solid #fdd835;
        display: flex; flex-direction: column; overflow: hidden;
        animation: fadeIn 0.5s ease;
    }

    .cen-img {
        width: 100%; flex-grow: 1; 
        display: flex; align-items: center; justify-content: center;
        padding: 0.5vh; min-height: 0;
    }
    .cen-img img { 
        max-height: 100%; max-width: 95%; 
        object-fit: contain; filter: drop-shadow(0 1vh 2vh rgba(0,0,0,0.2));
    }

    .cen-nome {
        width: 100%; flex-shrink: 0;
        text-align: center; color: #b71c1c; font-weight: 800; 
        font-size: 2.5vh; padding: 0 0.5vw 0.5vh 0.5vw; 
        line-height: 1.1; text-transform: uppercase;
        display: flex; align-items: center; justify-content: center;
    }
    .cen-nome span { display: block; max-height: 100%; overflow: hidden; }

    .cen-preco {
        width: 100%; height: 28%; flex-shrink: 0;
        background: rgba(255,255,255,0.5);
        border-top: 0.2vh solid rgba(0,0,0,0.1);
        display: flex; align-items: center; justify-content: center;
    }
    .cen-valor {
        font-family: 'Oswald', sans-serif; font-size: 7vh; 
        color: #d50000; font-weight: 700; letter-spacing: -0.2vh; line-height: 1;
    }
    .cen-rs { font-size: 2vh; color: #333; font-weight: bold; margin-top: -1.5vh; margin-right: 0.5vw;}
    .cen-un { font-size: 1.5vh; color: #555; font-weight: 700; align-self: flex-end; margin-bottom: 1.5vh; margin-left: 0.5vw;}

    /* Debug */
    #status-dot { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; transition: background 0.3s; }
    @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
</style>
</head>
<body>

    <div id="topo">
        <h1 id="titulo-texto">OFERTAS ESPECIAIS</h1>
    </div>

    <div id="main-container">
        <div class="col-lateral" id="col-esquerda"></div>
        <div class="col-central" id="col-centro"></div>
        <div class="col-lateral" id="col-direita"></div>
    </div>

    <div id="status-dot" title="Verde: Online | Azul: Cache Offline | Vermelho: Erro"></div>

    <script type="text/javascript">
        // --- CONFIGURAÇÃO CORRIGIDA PARA SEU SERVIDOR ---
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php'; 
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        
        var TEMPO_TROCA = 8000; // Tempo de rotação da página
        var ITENS_POR_PAGINA = 6; // 1 Esq + 4 Centro + 1 Dir
        var TEMPO_ATUALIZACAO = 3000; // Busca novos dados a cada 3s
        
        var listaGlobal = [];
        var indiceGlobal = 0;
        var usandoCache = false;
        var loopAtivo = false;

        function setStatus(cor) { var dot = document.getElementById('status-dot'); if(dot) dot.style.background = cor; }

        function salvarCache(dados) {
            try { localStorage.setItem('mga_141_cache', JSON.stringify(dados)); } catch (e) { }
        }

        function carregarCache() {
            try {
                var cache = localStorage.getItem('mga_141_cache');
                if (cache) {
                    var dados = JSON.parse(cache);
                    if (dados.length > 0) {
                        listaGlobal = dados;
                        usandoCache = true;
                        setStatus('blue'); 
                        if(!loopAtivo) iniciarLoops();
                        return true;
                    }
                }
            } catch (e) { }
            return false;
        }

        // --- FUNÇÃO DE CORREÇÃO DE IMAGEM (MESMA DO TVDUAL) ---
        function resolverImagem(img) {
            if(!img || img.length < 3) return placeholder;
            if(img.indexOf('http') === 0) return img;
            var urlAtual = window.location.href.split('?')[0];
            var pastaBase = urlAtual.substring(0, urlAtual.lastIndexOf('/') + 1);
            return pastaBase + img;
        }

        function buscarDados() {
            // Pega o UID da URL
            var urlParams = new URLSearchParams(window.location.search);
            var uid = urlParams.get('uid') || urlParams.get('loja') || 1;

            var xhr = new XMLHttpRequest();
            // Adiciona UID e timestamp para evitar cache
            var url = API_URL + '?uid=' + uid + '&t=' + new Date().getTime();
            
            xhr.open("GET", url, true);
            xhr.timeout = 2500; 

            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (Object.prototype.toString.call(dados) !== '[object Array]') dados = [dados];
                            
                            // Se vier vazio, limpa tudo
                            if (dados.length === 0) {
                                listaGlobal = [];
                                localStorage.removeItem('mga_141_cache');
                                renderizar(); // Limpa tela
                                setStatus('lime');
                                return;
                            }

                            // Verifica se mudou para salvar cache
                            if(JSON.stringify(dados) !== JSON.stringify(listaGlobal)) {
                                listaGlobal = dados;
                                salvarCache(dados);
                                if(!loopAtivo) iniciarLoops();
                                // Se o loop já existe, ele vai pegar os dados novos na próxima volta
                            }
                            
                            setStatus('lime');
                            usandoCache = false;

                        } catch (e) { 
                            if(listaGlobal.length === 0) carregarCache();
                            setStatus('orange'); 
                        }
                    } else {
                        // Erro de rede
                        if(listaGlobal.length === 0) carregarCache();
                        setStatus('red'); 
                    }
                }
            };
            xhr.send();
        }

        function getHtmlLateral(item) {
            if(!item) return '<div class="card-lateral" style="opacity:0"></div>';
            var img = resolverImagem(item.imagem);
            return `
            <div class="card-lateral">
                <div class="lat-tag">OFERTA</div>
                <div class="lat-img"><img src="${img}" onerror="this.src='${placeholder}'"></div>
                <div class="lat-nome"><span>${item.produto}</span></div>
                <div class="lat-footer">
                    <div class="lat-preco-box">
                        <span class="lat-rs">R$</span>
                        <span class="lat-valor">${item.preco}</span>
                        <span class="lat-un">/${item.unidade || 'un'}</span>
                    </div>
                </div>
            </div>`;
        }

        function getHtmlCentral(item) {
            if(!item) return '<div class="card-central" style="opacity:0"></div>';
            var img = resolverImagem(item.imagem);
            return `
            <div class="card-central">
                <div class="cen-img"><img src="${img}" onerror="this.src='${placeholder}'"></div>
                <div class="cen-nome"><span>${item.produto}</span></div>
                <div class="cen-preco">
                    <span class="cen-rs">R$</span>
                    <span class="cen-valor">${item.preco}</span>
                    <span class="cen-un">/${item.unidade || 'un'}</span>
                </div>
            </div>`;
        }

        function renderizar() {
            var colEsq = document.getElementById('col-esquerda');
            var colCen = document.getElementById('col-centro');
            var colDir = document.getElementById('col-direita');
            
            if (!colEsq) return;
            
            colEsq.innerHTML = ''; colCen.innerHTML = ''; colDir.innerHTML = '';

            if (listaGlobal.length === 0) {
                 colCen.innerHTML = '<div style="width:100%;height:100%;display:flex;align-items:center;justify-content:center;color:#888;font-size:3vh;">Aguardando ofertas...</div>';
                 return; 
            }

            // Loop para preencher os 6 espaços (1 esq + 4 centro + 1 dir)
            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                // Calcula índice circular
                var index = (indiceGlobal + i) % listaGlobal.length;
                var item = listaGlobal[index];
                
                if (i === 0) {
                    colEsq.innerHTML = getHtmlLateral(item);
                } else if (i >= 1 && i <= 4) {
                    colCen.innerHTML += getHtmlCentral(item);
                } else if (i === 5) {
                    colDir.innerHTML = getHtmlLateral(item);
                }
            }
            indiceGlobal += ITENS_POR_PAGINA;
        }

        function iniciarLoops() {
            if(loopAtivo) return;
            loopAtivo = true;
            renderizar(); // Renderiza imediatamente
            setInterval(renderizar, TEMPO_TROCA);
        }

        window.onload = function() {
            carregarCache();
            buscarDados();
            setInterval(buscarDados, TEMPO_ATUALIZACAO);
        };
    </script>
</body>
</html>