<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Lista + Destaque Controlado</title>
<style>
    /* --- RESET & GERAL --- */
    * { box-sizing: border-box; }
    body, html {
        margin: 0; padding: 0;
        width: 100%; height: 100%;
        overflow: hidden;
        background-color: #f4f4f4;
        font-family: 'Segoe UI', Helvetica, Arial, sans-serif;
    }

    /* --- CABEÇALHO (14%) --- */
    header {
        height: 14vh;
        background: #d32f2f;
        color: white;
        display: flex; align-items: center;
        padding: 0 3vw;
        box-shadow: 0 1vh 2vh rgba(0,0,0,0.2);
        position: relative; z-index: 10;
    }

    header h1 {
        font-size: 6vh; margin: 0; flex-grow: 1;
        text-transform: uppercase; font-weight: 800; letter-spacing: 0.2vw;
    }

    header .logo-area {
        font-size: 2.5vh; font-weight: 600;
        background: white; color: #d32f2f;
        padding: 1vh 2vw; border-radius: 5vh;
    }

    /* --- CONTAINER PRINCIPAL --- */
    #layout-principal {
        display: flex; 
        width: 100%;
        height: 86vh; 
        padding: 2vh 2vw;
        gap: 2vw; 
    }

    /* === COLUNA 1: LISTA (ESQUERDA - 65%) === */
    #coluna-lista {
        width: 65%; 
        height: 100%;
        display: flex; flex-direction: column; 
        gap: 1.5vh; 
    }

    .linha-produto {
        background: white;
        flex: 1; 
        border-radius: 2vh;
        display: flex; align-items: center;
        padding: 0 1.5vw;
        box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.05);
        border-left: 1.5vw solid #d32f2f;
        animation: entradaSuave 0.5s ease-out;
        overflow: hidden;
    }

    .linha-vazia {
        background: transparent !important;
        box-shadow: none !important;
        border: none !important;
        flex: 1; 
    }

    .img-tabela {
        height: 80%; aspect-ratio: 1/1; 
        object-fit: contain; margin-right: 1.5vw;
        background: #fff; border-radius: 1vh; border: 1px solid #eee;
    }

    .nome-tabela {
        flex-grow: 1;
        font-size: 4.5vh; 
        color: #333; font-weight: 700;
        white-space: nowrap; overflow: hidden; text-overflow: ellipsis;
        line-height: 1.1;
    }

    .preco-box-tabela { text-align: right; min-width: 15vw; }
    .moeda-tab { font-size: 2.5vh; color: #666; font-weight: bold; vertical-align: top; }
    .valor-tab { font-size: 7vh; font-weight: 800; color: #d32f2f; line-height: 1; }
    .un-tab { font-size: 2vh; color: #888; font-weight: 600; display: block;}


    /* === COLUNA 2: DESTAQUE (DIREITA - 33%) === */
    #coluna-destaque {
        width: 33%;
        height: 100%;
    }

    .card-destaque {
        width: 100%; height: 100%;
        background: white;
        border-radius: 3vh;
        box-shadow: 0 2vh 5vh rgba(0,0,0,0.2);
        border: 0.5vh solid #d32f2f;
        display: flex; flex-direction: column;
        overflow: hidden;
        position: relative;
    }

    .topo-destaque {
        height: 10%; 
        background: #d32f2f; color: #fff;
        display: flex; align-items: center; justify-content: center;
        font-size: 3vh; font-weight: 900; text-transform: uppercase;
        box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.1);
        z-index: 20;
    }

    .area-foto-destaque {
        height: 50%; width: 100%;
        padding: 2vh;
        display: flex; align-items: center; justify-content: center;
        background: radial-gradient(circle, #fff 0%, #eee 100%);
        overflow: hidden;
    }
    
    .foto-destaque {
        max-width: 95%; max-height: 95%;
        object-fit: contain;
        filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.3));
        transition: transform 0.5s;
    }

    .info-destaque {
        height: 40%; background: #fff;
        padding: 1vh 2vh; border-top: 1px solid #eee;
        display: flex; flex-direction: column;
        justify-content: center; align-items: center;
    }

    .nome-destaque {
        font-size: 3.5vh; color: #333; font-weight: 800;
        line-height: 1.1; margin-bottom: 1vh;
        text-transform: uppercase; text-align: center;
        max-height: 8vh; overflow: hidden;
    }

    .preco-container-destaque {
        display: flex; align-items: flex-start; justify-content: center;
        line-height: 1;
    }

    .rs-destaque {
        font-size: 4vh; color: #d32f2f; font-weight: bold;
        margin-right: 0.5vw; margin-top: 1vh;
    }

    .valor-destaque {
        font-family: 'Arial', sans-serif;
        font-size: 11vh; color: #d32f2f; font-weight: 900;
        letter-spacing: -0.3vh;
    }
    .un-destaque { 
        font-size: 2.5vh; color: #999; font-weight: bold; 
        align-self: flex-end; margin-bottom: 1.5vh; margin-left: 0.5vw;
    }

    /* Rodapé */
    .paginacao { position: absolute; bottom: 1vh; left: 3vw; font-size: 2vh; color: #999; }
    #indicador-rede { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }

    @keyframes entradaSuave { from { opacity: 0; transform: translateX(-2vw); } to { opacity: 1; transform: translateX(0); } }

</style>
</head>
<body>

    <header>
        <h1>Ofertas do Dia</h1>
        <div class="logo-area">Confira</div>
    </header>

    <div id="layout-principal">
        
        <div id="coluna-lista">
            </div>

        <div id="coluna-destaque">
            <div class="card-destaque" id="painel-destaque">
                <div class="topo-destaque">Super Oferta</div>
                <div class="area-foto-destaque">
                    <img id="img-d" src="" class="foto-destaque">
                </div>
                <div class="info-destaque">
                    <div id="nome-d" class="nome-destaque">...</div>
                    <div class="preco-container-destaque">
                        <span class="rs-destaque">R$</span>
                        <span id="preco-d" class="valor-destaque">...</span>
                        <span id="un-d" class="un-destaque"></span>
                    </div>
                </div>
            </div>
        </div>

    </div>
    
    <div class="paginacao" id="texto-paginacao"></div>
    <div id="indicador-rede" title="Status"></div>

    <script>
        // --- CONFIGURAÇÃO CORRIGIDA ---
        // Agora aponta para o seu arquivo local, não para o site de demonstração
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php'; 
        
        var ITENS_POR_LISTA = 5;      
        var TEMPO_PAGINA = 8000;      // 8 segs troca pagina da lista
        var TEMPO_DESTAQUE = 4000;    // 4 segs troca destaque
        var TEMPO_ATUALIZACAO = 3000; // 3 segs busca novos dados

        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        var dadosGlobais = [];
        var listaDestaques = [];
        var paginaAtual = 0;
        var indiceDestaque = 0;
        var loopAtivo = false;

        function baixarDados() {
            // --- PEGA O ID DA URL (uid) ---
            var urlParams = new URLSearchParams(window.location.search);
            var uid = urlParams.get('uid');
            
            // Se não tiver ID, tenta usar o 'loja' ou padrão 1, mas avisa no console
            if(!uid) {
                uid = urlParams.get('loja') || 1;
                console.log("Aviso: UID não encontrado na URL, usando padrão: " + uid);
            }

            // Pisca o indicador visual (Amarelo = Buscando)
            document.getElementById('indicador-rede').style.background = '#ffc107';

            var xhr = new XMLHttpRequest();
            // --- ENVIA O UID PARA O PHP ---
            xhr.open("GET", API_URL + '?uid=' + uid + '&t=' + new Date().getTime(), true);
            xhr.timeout = 2000; 

            xhr.onreadystatechange = function() {
                if(xhr.readyState == 4) {
                    if(xhr.status == 200) {
                        try {
                            var json = JSON.parse(xhr.responseText);
                            
                            var jsonStr = JSON.stringify(json);
                            var mudou = (localStorage.getItem('cache_dados') !== jsonStr);
                            
                            if (mudou || !loopAtivo) {
                                localStorage.setItem('cache_dados', jsonStr);
                                processarDados(json);
                                document.getElementById('indicador-rede').style.background = '#28a745'; // Verde
                            } else {
                                document.getElementById('indicador-rede').style.background = '#cccccc'; // Cinza
                            }

                        } catch(e) { console.log(e); document.getElementById('indicador-rede').style.background = '#dc3545'; }
                    } else {
                        document.getElementById('indicador-rede').style.background = '#dc3545';
                    }
                }
            };
            xhr.send();
        }

        function processarDados(dados) {
            dadosGlobais = Array.isArray(dados) ? dados : [];
            
            // Filtra destaques
            listaDestaques = dadosGlobais.filter(i => i.destaque == 1 || i.destaque == true);
            if(listaDestaques.length === 0) listaDestaques = dadosGlobais; 

            // Se for a primeira vez, inicia os loops
            if (!loopAtivo) {
                loopAtivo = true;
                atualizarLista();
                atualizarDestaque();
                setInterval(atualizarLista, TEMPO_PAGINA);
                setInterval(atualizarDestaque, TEMPO_DESTAQUE);
            } else {
                // Atualização visual imediata se a tela estava vazia ou se os dados sumiram
                if(document.getElementById('coluna-lista').children.length === 0 || dadosGlobais.length === 0) {
                    atualizarLista();
                    atualizarDestaque();
                }
            }
        }

        function atualizarLista() {
            var container = document.getElementById('coluna-lista');
            if(dadosGlobais.length === 0) {
                container.innerHTML = '<div style="display:flex;height:100%;align-items:center;justify-content:center;color:#aaa;font-size:3vh;">Aguardando ofertas...</div>';
                document.getElementById('texto-paginacao').innerText = '';
                return;
            }

            var totalPags = Math.ceil(dadosGlobais.length / ITENS_POR_LISTA);
            if(paginaAtual >= totalPags) paginaAtual = 0;

            var inicio = paginaAtual * ITENS_POR_LISTA;
            var fatia = dadosGlobais.slice(inicio, inicio + ITENS_POR_LISTA);

            container.innerHTML = '';
            fatia.forEach(item => {
                var imgFinal = (item.imagem && item.imagem.length > 5) ? item.imagem : placeholder;
                var html = `
                    <div class="linha-produto">
                        <img src="${imgFinal}" class="img-tabela" onerror="this.src='${placeholder}'">
                        <div class="nome-tabela">${item.produto}</div>
                        <div class="preco-box-tabela">
                            <span class="moeda-tab">R$</span>
                            <span class="valor-tab">${item.preco}</span>
                            <span class="un-tab">/${item.unidade || 'un'}</span>
                        </div>
                    </div>`;
                container.insertAdjacentHTML('beforeend', html);
            });
            
            while(container.children.length < ITENS_POR_LISTA) {
                container.insertAdjacentHTML('beforeend', '<div class="linha-vazia"></div>');
            }

            document.getElementById('texto-paginacao').innerText = `Pág ${paginaAtual+1}/${totalPags}`;
            paginaAtual++;
        }

        function atualizarDestaque() {
            var painel = document.getElementById('painel-destaque');
            if(listaDestaques.length === 0) { painel.style.opacity = 0; return; }
            painel.style.opacity = 0.8; 

            setTimeout(() => {
                if(indiceDestaque >= listaDestaques.length) indiceDestaque = 0;
                var item = listaDestaques[indiceDestaque];
                var imgFinal = (item.imagem && item.imagem.length > 5) ? item.imagem : placeholder;

                document.getElementById('img-d').src = imgFinal;
                document.getElementById('img-d').onerror = function(){ this.src = placeholder; };
                
                document.getElementById('nome-d').innerText = item.produto;
                document.getElementById('preco-d').innerText = item.preco;
                document.getElementById('un-d').innerText = '/' + (item.unidade || 'un');
                
                painel.style.opacity = 1;
                indiceDestaque++;
            }, 200);
        }

        window.onload = function() {
            baixarDados();
            setInterval(baixarDados, TEMPO_ATUALIZACAO);
        };

    </script>
</body>
</html>