<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Oferta Premium MGA - 1920x1080</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100vw; 
        height: 100vh;
        overflow: hidden; /* Remove barras de rolagem */
        background: #0f0f0f; 
        background: radial-gradient(circle at 30% 50%, #2a2a2a 0%, #000000 100%);
        font-family: 'Montserrat', Arial, sans-serif;
    }

    /* --- CONTAINER PRINCIPAL (Flexbox) --- */
    #tela-unica {
        width: 100%; height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 4vh; /* Margem de segurança da borda da TV */
    }

    .produto-container {
        width: 100%; height: 100%;
        display: flex; /* Divide esquerda e direita */
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
    }

    /* --- LADO ESQUERDO: IMAGEM --- */
    .area-img-left {
        width: 45%; 
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }
    
    .area-img-left img {
        max-width: 100%;
        max-height: 90%;
        object-fit: contain;
        /* Sombra 3D muito forte para destacar do fundo */
        filter: drop-shadow(15px 30px 40px rgba(0,0,0,0.8));
        transform: scale(1.0);
        transition: transform 0.5s ease;
    }

    /* --- LADO DIREITO: INFORMAÇÕES --- */
    .area-info-right {
        width: 55%; 
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center; /* Centraliza verticalmente */
        padding-left: 4vw;
        text-align: left;
    }

    /* TÍTULO DO PRODUTO */
    .nome-prod-texto {
        /* Tamanho responsivo: 7% da altura da tela */
        font-size: 7vh; 
        font-weight: 900; 
        color: #ffffff; 
        line-height: 1.1;
        text-transform: uppercase;
        margin-bottom: 2vh;
        
        /* Proteção para nomes muito longos (máximo 3 linhas) */
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        
        text-shadow: 4px 4px 15px rgba(0,0,0,0.8);
    }

    /* CLUSTER DE PREÇO */
    .preco-container {
        display: flex;
        align-items: flex-start; /* Alinha o R$ ao topo do número */
        line-height: 1;
        margin-top: 1vh;
    }

    /* R$ */
    .simbolo-moeda {
        font-size: 6vh; /* Grande, mas menor que o preço */
        color: #ffc107; /* Amarelo Ouro */
        font-weight: 700;
        margin-top: 3vh; /* Empurra um pouco pra baixo para alinhar bonito */
        margin-right: 1vw;
    }

    /* VALOR NUMÉRICO */
    .valor-gigante {
        font-family: 'Anton', sans-serif;
        font-size: 32vh; /* GIGANTE: Ocupa 32% da altura da tela */
        color: #ffffff;
        letter-spacing: -0.05em; /* Junta os números */
        text-shadow: 8px 8px 30px rgba(0,0,0,0.9);
    }

    /* UNIDADE (Kg/Un) */
    .unidade-medida {
        font-size: 5vh;
        color: #ffc107;
        font-weight: 700;
        align-self: flex-end; /* Fica no pé do número */
        margin-bottom: 5vh;
        margin-left: 1vw;
    }

    /* MENSAGEM DE CARREGAMENTO */
    .loading-msg {
        color: rgba(255,255,255,0.4);
        font-size: 5vh;
        text-align: center;
        width: 100%;
    }

    /* Debug Dot */
    #status-dot { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: red; z-index: 9999; opacity: 0.5; }
</style>
</head>
<body>

    <div id="tela-unica">
        <div id="container-produto" style="width:100%; height:100%;">
            <div class="loading-msg">Carregando ofertas...</div>
        </div>
    </div>

    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var CATEGORIA_FILTRO = ''; 
        
        var TEMPO_TROCA = 8000; 
        
        var listaGlobal = [];
        var indiceGlobal = 0;
        var erroCont = 0;

        function setStatus(cor) { var dot = document.getElementById('status-dot'); if(dot) dot.style.background = cor; }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            if (CATEGORIA_FILTRO !== '') url += '&categoria=' + encodeURIComponent(CATEGORIA_FILTRO);
            
            xhr.open("GET", url, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (Object.prototype.toString.call(dados) !== '[object Array]') dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else { setStatus('yellow'); }
                        } catch (e) { setStatus('orange'); }
                    } else {
                        setStatus('red'); erroCont++;
                        // Fallback http se https falhar muito
                        if(erroCont > 2 && API_URL.indexOf('https') === 0) { API_URL = API_URL.replace('https', 'http'); erroCont = 0; }
                    }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('container-produto');
            if (!container) return;
            
            if (listaGlobal.length === 0) { buscarDados(); return; }

            var atual = indiceGlobal % listaGlobal.length;
            var item = listaGlobal[atual];
            
            var precoShow = item.preco;
            var unidadeShow = item.unidade || 'un';
            
            // Tratamento da imagem
            var imgShow = 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png'; 
            if (item.imagem && item.imagem.length > 10) imgShow = item.imagem;

            var nomeProd = item.produto || "Oferta Especial";

            // HTML OTIMIZADO
            var html = '';
            html += '<div class="produto-container">';
            
            // Esquerda
            html += '  <div class="area-img-left">';
            html += '    <img src="' + imgShow + '" onerror="this.src=\'https://cdn-icons-png.flaticon.com/512/3143/3143643.png\'">';
            html += '  </div>';
            
            // Direita
            html += '  <div class="area-info-right">';
            html += '    <div class="nome-prod-texto">' + nomeProd + '</div>';
            
            html += '    <div class="preco-container">';
            html += '       <div class="simbolo-moeda">R$</div>';
            html += '       <div class="valor-gigante">' + precoShow + '</div>';
            html += '       <div class="unidade-medida">/' + unidadeShow + '</div>';
            html += '    </div>';
            
            html += '  </div>'; 
            html += '</div>';

            // Efeito de Fade suave na troca (opcional, mas fica bonito)
            container.style.opacity = 0;
            setTimeout(function(){
                container.innerHTML = html;
                container.style.opacity = 1;
            }, 200);
            
            indiceGlobal++;
        }

        // Adiciona transição CSS via JS para o fade funcionar
        document.getElementById('container-produto').style.transition = "opacity 0.5s ease";

        window.onload = function() {
            buscarDados();
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000); // Atualiza dados a cada 1 min
        };
    </script>
</body>
</html>