<?php
require 'lock.php';
require 'config.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$produto = null;

// --- 1. BUSCAR DADOS PARA OS SELECTS (Categorias e Filiais) ---
$categorias = $pdo->query("SELECT * FROM categorias ORDER BY nome ASC")->fetchAll(PDO::FETCH_ASSOC);
$filiais    = $pdo->query("SELECT * FROM filiais ORDER BY nome ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- 2. SE FOR EDIÇÃO, BUSCA O PRODUTO ---
if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM ofertas WHERE id = ?");
    $stmt->execute([$id]);
    $produto = $stmt->fetch(PDO::FETCH_ASSOC);
}

// --- 3. SALVAR (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome           = $_POST['produto'];
    $preco          = $_POST['preco'];
    $unidade        = $_POST['unidade'];
    $categoria      = $_POST['categoria']; // Salva o NOME da categoria
    $filial_id      = !empty($_POST['filial_id']) ? $_POST['filial_id'] : null; // Salva o ID da filial
    $destaque       = isset($_POST['destaque']) ? 1 : 0;
    $ativo          = $_POST['ativo']; // 1 ou 0
    $codigo_balanca = $_POST['codigo_balanca'];

    // Upload de Imagem
    $imagem = $produto['imagem'] ?? ''; // Mantém a antiga se não enviar nova
    if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === 0) {
        $ext = pathinfo($_FILES['imagem']['name'], PATHINFO_EXTENSION);
        $novo_nome = "assets/uploads/" . uniqid() . "." . $ext;
        if (move_uploaded_file($_FILES['imagem']['tmp_name'], $novo_nome)) {
            $imagem = $novo_nome;
        }
    }

    if ($id) {
        // ATUALIZAR
        $sql = "UPDATE ofertas SET produto=?, preco=?, unidade=?, categoria=?, filial_id=?, destaque=?, ativo=?, codigo_balanca=?, imagem=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nome, $preco, $unidade, $categoria, $filial_id, $destaque, $ativo, $codigo_balanca, $imagem, $id]);
    } else {
        // INSERIR NOVO
        $sql = "INSERT INTO ofertas (produto, preco, unidade, categoria, filial_id, destaque, ativo, codigo_balanca, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nome, $preco, $unidade, $categoria, $filial_id, $destaque, $ativo, $codigo_balanca, $imagem]);
    }

    header("Location: painel.php?msg=salvo");
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title><?= $id ? 'Editar' : 'Novo' ?> Produto</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><?= $id ? 'Editar Produto' : 'Cadastrar Novo Produto' ?></h4>
            <a href="painel.php" class="btn btn-sm btn-light">Voltar</a>
        </div>
        <div class="card-body">
            
            <form method="POST" enctype="multipart/form-data">
                
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Status de Exibição</label>
                        <select name="ativo" class="form-select">
                            <option value="1" <?= ($produto && $produto['ativo'] == 1) ? 'selected' : '' ?>>🟢 Ativo (Visível)</option>
                            <option value="0" <?= ($produto && $produto['ativo'] == 0) ? 'selected' : '' ?>>🔴 Suspenso (Oculto)</option>
                        </select>
                    </div>

                    <div class="col-md-3 d-flex align-items-end">
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" name="destaque" id="destaque" <?= ($produto && $produto['destaque']) ? 'checked' : '' ?>>
                            <label class="form-check-label fw-bold text-warning" for="destaque">⭐ Produto em Destaque?</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Nome do Produto</label>
                        <input type="text" name="produto" class="form-control" required value="<?= $produto['produto'] ?? '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Preço (R$)</label>
                        <input type="text" name="preco" class="form-control" required value="<?= $produto['preco'] ?? '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Unidade</label>
                        <input type="text" name="unidade" class="form-control" placeholder="ex: un, kg, pc" value="<?= $produto['unidade'] ?? 'un' ?>">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Categoria</label>
                        <div class="input-group">
                            <select name="categoria" class="form-select">
                                <option value="">Sem Categoria</option>
                                <?php foreach($categorias as $cat): ?>
                                    <option value="<?= $cat['nome'] ?>" 
                                        <?= ($produto && $produto['categoria'] == $cat['nome']) ? 'selected' : '' ?>>
                                        <?= $cat['nome'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <button class="btn btn-outline-secondary" type="button" onclick="window.location.href='painel.php'"><i class="bi bi-gear"></i></button>
                        </div>
                        <div class="form-text">Gerencie categorias no Painel.</div>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Filial (Opcional)</label>
                        <select name="filial_id" class="form-select">
                            <option value="">Todas as lojas</option>
                            <?php foreach($filiais as $fil): ?>
                                <option value="<?= $fil['id'] ?>" 
                                    <?= ($produto && $produto['filial_id'] == $fil['id']) ? 'selected' : '' ?>>
                                    <?= $fil['nome'] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Código Balança (Opcional)</label>
                        <input type="number" name="codigo_balanca" class="form-control" value="<?= $produto['codigo_balanca'] ?? '' ?>">
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Imagem do Produto</label>
                    <input type="file" name="imagem" class="form-control" accept="image/*">
                    <?php if(!empty($produto['imagem'])): ?>
                        <div class="mt-2">
                            <img src="<?= $produto['imagem'] ?>" height="80" class="border rounded">
                            <span class="text-muted small ms-2">Imagem Atual</span>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-success btn-lg fw-bold">
                        <i class="bi bi-save"></i> SALVAR PRODUTO
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>