<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Ofertas MGA</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Roboto:wght@700&display=swap" rel="stylesheet">
<style type="text/css">
    /* RESET */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background-color: #b71c1c; 
        background: radial-gradient(circle, #e53935 10%, #b71c1c 90%);
        font-family: 'Roboto', Arial, sans-serif;
        overflow: hidden;
    }

    /* TOPO */
    #topo {
        position: absolute; top: 0; left: 0; width: 100%; height: 15%;
        background-color: rgba(0,0,0,0.2);
        border-bottom: 4px solid #ffeb3b;
        text-align: center;
        z-index: 100;
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    }
    #topo h1 {
        font-family: 'Anton', Arial, sans-serif;
        font-size: 60px; color: #ffeb3b;
        line-height: 1.4; 
        text-transform: uppercase; margin: 0;
        text-shadow: 4px 4px 0 #000;
        letter-spacing: 3px;
    }

    /* LISTA */
    #lista-produtos {
        position: absolute; top: 15%; left: 0; width: 100%; height: 85%;
        padding: 30px 20px;
    }

    /* CARD */
    .cartao {
        width: 31%; 
        height: 92%; 
        background: white;
        margin: 0 1.1%; 
        float: left;
        border-radius: 20px;
        border: 5px solid white;
        position: relative; 
        box-shadow: 0 15px 30px rgba(0,0,0,0.5);
        overflow: hidden; 
    }

    /* FAIXA CATEGORIA */
    .faixa-cat {
        background: #0d47a1; color: white; width: 100%; text-align: center;
        padding: 6px 0; font-weight: bold; font-size: 18px; text-transform: uppercase;
        position: absolute; top: 0; left: 0; z-index: 20;
        box-shadow: 0 2px 5px rgba(0,0,0,0.3);
    }

    /* FOTO */
    .area-img {
        position: relative;
        top: 1%; 
        left: 0;
        width: auto; 
        height: 90%; 
        text-align: center;
        z-index: 10;
        background: transparent;
        display: flex; 
        align-items: center; 
        justify-content: center;
    }
    .area-img img {
        max-height: 105%; max-width: auto;
        width: auto; height: auto;
        object-fit: contain; 
        filter: drop-shadow(0 10px 10px rgba(0,0,0,0.15));
    }

    /* NOME */
    .nome-prod-box {
        position: absolute;
        top: 5%; 
        left: 0;
        width: 100%;
        height: 18%; 
        display: table; 
        z-index: 50; 
        background: rgba(255,255,255,0.5); 
        padding: 0 5px;
    }
    .nome-prod-texto {
        display: table-cell;
        vertical-align: middle;
        text-align: center;
        font-size: 60px; 
        font-weight: 900; 
        color: #222; 
        line-height: 1.1;
        text-transform: uppercase;
    }

    /* --- ÁREA DE PREÇO (REFEITA PARA FICAR JUNTO) --- */
    .area-preco {
        position: absolute; bottom: 0; left: 0; 
        width: 100%; height: 34%; 
        background-color: #ffeb3b; 
        border-radius: 0 0 15px 15px;
        text-align: center;
        z-index: 20;
        
        clip-path: polygon(0 15%, 100% 0, 100% 100%, 0% 100%);
        -webkit-clip-path: polygon(0 15%, 100% 0, 100% 100%, 0% 100%);
        border-top: 5px solid #fdd835; 
        
        /* Centraliza o bloco de preço verticalmente */
        display: table; 
    }
    
    .preco-container-center {
        display: table-cell; 
        vertical-align: middle; 
        padding-top: 20px; /* Compensa o corte diagonal */
    }

    /* Elementos Inline para ficarem colados */
    .rs {
        display: inline-block;
        font-size: 35px; 
        color: #b71c1c; 
        font-weight: bold;
        vertical-align: top; /* Alinha no topo do número */
        margin-right: 5px;
        margin-top: 15px; /* Ajuste fino */
    }
    
    .valor-grande {
        display: inline-block;
        font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 110px; /* GIGANTE */
        color: #d50000; 
        line-height: 1;
        letter-spacing: -4px; /* Junta os números */
        text-shadow: 3px 3px 0px white;
    }
    
    .unidade {
        display: inline-block;
        font-size: 22px; 
        color: #333; 
        font-weight: bold;
        vertical-align: bottom; /* Alinha na base do número */
        margin-left: 5px;
        margin-bottom: 20px; /* Ajuste fino */
        text-transform: lowercase;
    }

    /* Debug Dot */
    #status-dot {
        position: fixed; bottom: 5px; right: 5px;
        width: 10px; height: 10px; border-radius: 50%;
        background: red; z-index: 9999;
    }

</style>
</head>
<body>

    <div id="topo">
        <h1 id="titulo-texto">SUPER OFERTAS</h1>
    </div>

    <div id="lista-produtos">
        <h2 style="text-align:center; color:white; margin-top:50px;">Carregando...</h2>
    </div>

    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var CATEGORIA_FILTRO = ''; 
        var TEMPO_TROCA = 10000;
        var ITENS_POR_PAGINA = 3;
        
        var listaGlobal = [];
        var indiceGlobal = 0;
        var erroCont = 0;

        function setStatus(cor) {
            var dot = document.getElementById('status-dot');
            if(dot) dot.style.background = cor;
        }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            var url = API_URL + '?t=' + new Date().getTime();
            if (CATEGORIA_FILTRO !== '') url += '&categoria=' + encodeURIComponent(CATEGORIA_FILTRO);
            
            xhr.open("GET", url, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (Object.prototype.toString.call(dados) !== '[object Array]') dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else {
                                setStatus('yellow');
                            }
                        } catch (e) { setStatus('orange'); }
                    } else {
                        setStatus('red');
                        erroCont++;
                        if(erroCont > 2 && API_URL.indexOf('https') === 0) {
                            API_URL = API_URL.replace('https', 'http');
                            erroCont = 0;
                        }
                    }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('lista-produtos');
            if (!container) return;
            container.innerHTML = ''; 

            if (listaGlobal.length === 0) { buscarDados(); return; }

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var atual = (indiceGlobal + i) % listaGlobal.length;
                var item = listaGlobal[atual];
                
                var precoShow = item.preco;
                var imgShow = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
                if (item.imagem && item.imagem.length > 10) imgShow = item.imagem;

                var tituloCat = item.categoria || 'OFERTA';
                if (CATEGORIA_FILTRO !== '') {
                    var h1 = document.getElementById('titulo-texto');
                    if(h1) h1.innerHTML = 'OFERTAS - ' + CATEGORIA_FILTRO;
                }

                var nomeProd = item.produto || "Produto";

                var html = '';
                html += '<div class="cartao">';
                html += '  <div class="faixa-cat">' + tituloCat + '</div>';
                
                html += '  <div class="area-img">';
                html += '    <img src="' + imgShow + '" onerror="this.style.display=\'none\'">';
                html += '  </div>';
                
                html += '  <div class="nome-prod-box">';
                html += '    <div class="nome-prod-texto">' + nomeProd + '</div>';
                html += '  </div>';
                
                // PREÇO COMPACTO E CENTRALIZADO
                html += '  <div class="area-preco">';
                html += '    <div class="preco-container-center">';
                html += '      <span class="rs">R$</span>';
                html += '      <span class="valor-grande">' + precoShow + '</span>';
                html += '      <span class="unidade">/' + (item.unidade || 'un') + '</span>';
                html += '    </div>';
                html += '  </div>';
                html += '</div>';

                container.innerHTML += html;
            }
            indiceGlobal += ITENS_POR_PAGINA;
        }

        window.onload = function() {
            buscarDados();
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>