<?php
// --- CONFIGURAÇÕES ---
$arquivo_db = 'ofertas_db.json'; // Base de dados em arquivo JSON (simples e rápido)
$pasta_upload = 'uploads/';      // Pasta onde salvará as mídias

// Cria a pasta se não existir
if (!file_exists($pasta_upload)) mkdir($pasta_upload, 0777, true);

// --- PROCESSAMENTO DO FORMULÁRIO (SALVAR) ---
$mensagem = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'salvar') {
    
    $dados = [
        'id' => uniqid(),
        'produto' => $_POST['produto'],
        'preco' => $_POST['preco'],
        'unidade' => $_POST['unidade'],
        'agendamento' => $_POST['agendamento'], // 'sempre' ou 'agenda'
        'data_inicio' => $_POST['data_inicio'] ?? '',
        'data_fim' => $_POST['data_fim'] ?? '',
        'hora_inicio' => $_POST['hora_inicio'] ?? '',
        'hora_fim' => $_POST['hora_fim'] ?? '',
        'destaque' => (isset($_POST['destaque']) ? 1 : 0),
        'tipo_midia' => 'imagem', // padrão
        'imagem' => '' // url
    ];

    // Upload de Arquivo
    if (isset($_FILES['arquivo']) && $_FILES['arquivo']['error'] === 0) {
        $ext = strtolower(pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION));
        $novo_nome = uniqid() . '.' . $ext;
        $destino = $pasta_upload . $novo_nome;

        // Verifica se é vídeo ou imagem
        $videos = ['mp4', 'webm', 'ogg', 'mov'];
        if (in_array($ext, $videos)) {
            $dados['tipo_midia'] = 'video';
        }

        if (move_uploaded_file($_FILES['arquivo']['tmp_name'], $destino)) {
            // Salva a URL completa para facilitar
            $dados['imagem'] = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['REQUEST_URI']) . '/' . $destino;
            
            // --- SALVAR NO JSON (SIMULANDO BANCO DE DADOS) ---
            $db_atual = file_exists($arquivo_db) ? json_decode(file_get_contents($arquivo_db), true) : [];
            // Adiciona no início
            array_unshift($db_atual, $dados);
            // Salva apenas os últimos 20 itens para não pesar
            $db_atual = array_slice($db_atual, 0, 20);
            
            file_put_contents($arquivo_db, json_encode($db_atual, JSON_PRETTY_PRINT));
            $mensagem = '<div class="alert success">Oferta salva com sucesso!</div>';
        } else {
            $mensagem = '<div class="alert error">Erro ao mover arquivo. Verifique permissões da pasta.</div>';
        }
    } else {
        $mensagem = '<div class="alert error">Selecione uma imagem ou vídeo.</div>';
    }
}

// --- MODO API (SE O PLAYER CHAMAR ESTE ARQUIVO) ---
// Se houver parâmetro ?uid ou ?t na URL, entende-se que é o player pedindo dados
if (isset($_GET['t']) || isset($_GET['uid'])) {
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    if (file_exists($arquivo_db)) {
        echo file_get_contents($arquivo_db);
    } else {
        echo json_encode([]);
    }
    exit; // Encerra o script aqui para não exibir o HTML do painel
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Painel MGA Premium</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<style>
    /* Estilo Clean e Moderno */
    body { font-family: 'Roboto', sans-serif; background: #f4f7f6; margin: 0; padding: 20px; color: #333; }
    .container { max-width: 800px; margin: 0 auto; background: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
    
    h1 { color: #d32f2f; margin-top: 0; border-bottom: 2px solid #eee; padding-bottom: 15px; }
    
    .form-group { margin-bottom: 15px; }
    label { display: block; font-weight: 500; margin-bottom: 5px; color: #555; }
    input[type="text"], input[type="number"], input[type="date"], input[type="time"], select {
        width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 16px; box-sizing: border-box;
    }
    
    /* Área de Upload */
    .file-area { border: 2px dashed #d32f2f; padding: 20px; text-align: center; border-radius: 5px; background: #fafafa; cursor: pointer; }
    .file-area:hover { background: #fee; }
    
    /* Agendamento */
    .schedule-box { background: #e3f2fd; padding: 15px; border-radius: 5px; display: none; /* Oculto por padrão */ border: 1px solid #bbdefb; }
    .row { display: flex; gap: 10px; }
    .col { flex: 1; }

    /* Botão */
    button.btn-save {
        width: 100%; padding: 15px; background: #d32f2f; color: white; border: none; border-radius: 5px; font-size: 18px; font-weight: bold; cursor: pointer; transition: background 0.3s;
        margin-top: 20px;
    }
    button.btn-save:hover { background: #b71c1c; }

    /* Alertas */
    .alert { padding: 15px; margin-bottom: 20px; border-radius: 5px; }
    .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }

    /* Radio Group */
    .radio-group { display: flex; gap: 20px; margin-bottom: 10px; }
    .radio-option { display: flex; align-items: center; cursor: pointer; }
    .radio-option input { margin-right: 5px; transform: scale(1.2); }

    /* Preview */
    .preview-box { margin-top: 30px; border-top: 2px solid #eee; padding-top: 20px; }
    .item-lista { display: flex; align-items: center; padding: 10px; border-bottom: 1px solid #eee; }
    .item-lista img, .item-lista video { width: 60px; height: 60px; object-fit: cover; border-radius: 5px; margin-right: 15px; }
    .badge { padding: 3px 8px; border-radius: 4px; font-size: 12px; color: white; font-weight: bold; }
    .badge-video { background: #9c27b0; }
    .badge-img { background: #2196f3; }
</style>
</head>
<body>

<div class="container">
    <h1>Gerenciador de Ofertas Premium</h1>
    
    <?php echo $mensagem; ?>

    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="acao" value="salvar">

        <div class="form-group">
            <label>Nome do Produto / Título da Oferta</label>
            <input type="text" name="produto" placeholder="Ex: Coca Cola 2L" required>
        </div>

        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label>Preço (R$)</label>
                    <input type="text" name="preco" placeholder="0,00" required>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label>Unidade</label>
                    <select name="unidade">
                        <option value="un">Unidade (un)</option>
                        <option value="kg">Quilo (kg)</option>
                        <option value="cx">Caixa (cx)</option>
                        <option value="pc">Peça (pc)</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label>Upload de Mídia (Imagem ou Vídeo)</label>
            <div class="file-area" onclick="document.getElementById('fileInput').click()">
                <span id="fileName">Clique para selecionar Imagem (.jpg, .png) ou Vídeo (.mp4)</span>
                <input type="file" name="arquivo" id="fileInput" style="display:none" accept="image/*,video/*" onchange="updateFileName(this)" required>
            </div>
            <small style="color: #666;">Para vídeos, o tamanho máximo depende da configuração do seu PHP (upload_max_filesize).</small>
        </div>

        <div class="form-group" style="background: #fff3cd; padding: 10px; border-radius: 5px; border: 1px solid #ffeeba;">
            <label style="display:inline-flex; align-items:center; cursor:pointer; width:100%; margin:0;">
                <input type="checkbox" name="destaque" value="1" style="width:auto; margin-right:10px; transform:scale(1.5);">
                <strong>Exibir como Super Destaque (Tela Cheia / Lateral)?</strong>
            </label>
        </div>

        <div class="form-group">
            <label>Programação da Oferta</label>
            <div class="radio-group">
                <label class="radio-option">
                    <input type="radio" name="agendamento" value="sempre" checked onclick="toggleAgenda(false)">
                    Exibir Sempre (Rodízio normal)
                </label>
                <label class="radio-option">
                    <input type="radio" name="agendamento" value="agenda" onclick="toggleAgenda(true)">
                    Agendar Horário/Data (Custom)
                </label>
            </div>
        </div>

        <div id="box-agenda" class="schedule-box">
            <div class="row">
                <div class="col">
                    <label>Data Início</label>
                    <input type="date" name="data_inicio">
                </div>
                <div class="col">
                    <label>Data Fim</label>
                    <input type="date" name="data_fim">
                </div>
            </div>
            <div class="row" style="margin-top:10px;">
                <div class="col">
                    <label>Hora Início</label>
                    <input type="time" name="hora_inicio">
                </div>
                <div class="col">
                    <label>Hora Fim</label>
                    <input type="time" name="hora_fim">
                </div>
            </div>
            <small>Deixe em branco qualquer campo que não queira restringir.</small>
        </div>

        <button type="submit" class="btn-save">SALVAR OFERTA</button>
    </form>

    <div class="preview-box">
        <h3>Últimas Ofertas Cadastradas</h3>
        <?php
        if (file_exists($arquivo_db)) {
            $itens = json_decode(file_get_contents($arquivo_db), true);
            if ($itens) {
                foreach ($itens as $item) {
                    $badge = ($item['tipo_midia'] == 'video') ? '<span class="badge badge-video">VÍDEO</span>' : '<span class="badge badge-img">IMG</span>';
                    $agenda = ($item['agendamento'] == 'agenda') ? '🕒 Agendado' : '♾️ Sempre';
                    
                    // Mostra thumbnail
                    $midia = ($item['tipo_midia'] == 'video') 
                        ? '<video src="'.$item['imagem'].'" muted></video>' 
                        : '<img src="'.$item['imagem'].'">';

                    echo "<div class='item-lista'>
                            $midia
                            <div style='flex-grow:1'>
                                <strong>{$item['produto']}</strong> <br>
                                R$ {$item['preco']} / {$item['unidade']}
                            </div>
                            <div style='text-align:right'>
                                $badge <br>
                                <small>$agenda</small>
                            </div>
                          </div>";
                }
            } else {
                echo "<p style='color:#777'>Nenhuma oferta cadastrada.</p>";
            }
        }
        ?>
    </div>
</div>

<script>
    function toggleAgenda(ativar) {
        var box = document.getElementById('box-agenda');
        box.style.display = ativar ? 'block' : 'none';
    }

    function updateFileName(input) {
        var name = input.files[0] ? input.files[0].name : 'Clique para selecionar...';
        document.getElementById('fileName').innerText = 'Selecionado: ' + name;
        document.getElementById('fileName').style.fontWeight = 'bold';
        document.getElementById('fileName').style.color = '#d32f2f';
    }
</script>

</body>
</html>