<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Ofertas Premium</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body, html {
        width: 100%; height: 100%;
        background: radial-gradient(circle, #333 0%, #000 100%);
        font-family: 'Montserrat', 'Arial', sans-serif; /* Fonte Android Friendly */
        overflow: hidden;
    }

    #topo {
        position: absolute; top: 0; left: 0; width: 100%; height: 15vh;
        background-color: rgba(255,193,7, 0.1); 
        border-bottom: 0.5vh solid #ffc107;
        text-align: center; display: flex; align-items: center; justify-content: center;
    }
    #topo h1 {
        font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 8vh; color: #ffc107; 
        text-transform: uppercase; margin: 0;
        text-shadow: 0.4vh 0.4vh 1vh #000; letter-spacing: 0.5vw;
    }

    #lista-produtos {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 2vh 1vw; display: flex; justify-content: space-between; 
    }

    .cartao {
        width: 32.5%; height: 100%; 
        background: #222; border-radius: 2vh; border: 0.3vh solid #444; 
        box-shadow: 0 2vh 5vh rgba(0,0,0,0.8); overflow: hidden; display: flex; flex-direction: column;
    }

    .faixa-cat {
        background: #ffc107; color: #000; width: 100%; text-align: center;
        padding: 0.5vh 0; font-weight: 900; font-size: 2.5vh; text-transform: uppercase;
        flex-shrink: 0; 
    }

    .area-img {
        width: 100%; flex-grow: 1; position: relative;
        display: flex; align-items: center; justify-content: center;
        padding: 1vh; overflow: hidden;
    }
    .area-img img {
        max-height: 100%; max-width: 95%; object-fit: contain; 
        filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.6));
    }

    .nome-prod-box {
        width: 100%; min-height: 15%; 
        display: flex; align-items: center; justify-content: center;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.8)); 
        flex-shrink: 0; padding: 0 1vw;
    }
    .nome-prod-texto {
        text-align: center; font-size: 3.5vh; font-weight: 700; color: #fff; 
        text-transform: uppercase; line-height: 1.1; text-shadow: 0.3vh 0.3vh 0.5vh black;
    }

    .area-preco {
        width: 100%; height: 30%; 
        background: linear-gradient(to bottom, #2a2a2a 0%, #1a1a1a 100%);
        border-top: 0.2vh solid #444; display: flex; align-items: center; justify-content: center; flex-shrink: 0; 
    }
    
    .preco-wrapper { display: flex; align-items: flex-start; justify-content: center; line-height: 1; }
    .rs { font-size: 4vh; color: #ffc107; font-weight: bold; margin-top: 1vh; margin-right: 0.5vw; }
    .valor-grande { font-family: 'Anton', 'Arial Black', sans-serif; font-size: 14vh; color: #fff; letter-spacing: -0.5vh; }
    .unidade { font-size: 2.5vh; color: #999; font-weight: bold; align-self: flex-end; margin-bottom: 2vh; margin-left: 0.5vw; text-transform: lowercase; }

    #status-dot { position: fixed; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }
</style>
</head>
<body>
    <div id="topo"><h1 id="titulo-texto">OFERTAS ESPECIAIS</h1></div>
    <div id="lista-produtos"><h2 style="margin:auto;color:#777;">Carregando...</h2></div>
    <div id="status-dot"></div>

    <script type="text/javascript">
        var API_URL = 'https://mgaplay.com.br/ofertas/destaque-mercado.php';
        var TEMPO_TROCA = 10000;
        var ITENS_POR_PAGINA = 3; 
        var listaGlobal = [];
        var indiceGlobal = 0;

        function formatarMoeda(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            return isNaN(v) ? valor : v.toFixed(2).replace('.', ',');
        }
        function salvarCache(dados) { try { localStorage.setItem('mga_premium_cache', JSON.stringify(dados)); } catch (e) {} }
        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_premium_cache');
                if (c) {
                    var d = JSON.parse(c);
                    if (d.length > 0) { listaGlobal = d; setStatus('blue'); if (indiceGlobal === 0) renderizar(); return true; }
                }
            } catch (e) {}
            return false;
        }
        function setStatus(cor) { document.getElementById('status-dot').style.background = cor; }

        function buscarDados() {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", API_URL + '?t=' + new Date().getTime(), true);
            xhr.timeout = 5000;
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4) {
                    if (xhr.status == 200) {
                        try {
                            var dados = JSON.parse(xhr.responseText);
                            if (!Array.isArray(dados)) dados = [dados];
                            if (dados.length > 0) {
                                listaGlobal = dados;
                                salvarCache(dados);
                                setStatus('lime');
                                if (indiceGlobal === 0) renderizar();
                            } else { if(listaGlobal.length==0) carregarCache(); }
                        } catch (e) { if(listaGlobal.length==0) carregarCache(); }
                    } else { if(listaGlobal.length==0) carregarCache(); }
                }
            };
            xhr.send();
        }

        function renderizar() {
            var container = document.getElementById('lista-produtos');
            if (listaGlobal.length === 0) return;
            container.innerHTML = ''; 
            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var atual = (indiceGlobal + i) % listaGlobal.length;
                var item = listaGlobal[atual];
                var imgShow = (item.imagem && item.imagem.length > 10) ? item.imagem : 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png';
                var html = `
                <div class="cartao">
                    <div class="faixa-cat">${item.categoria || 'OFERTA'}</div>
                    <div class="area-img"><img src="${imgShow}" onerror="this.style.display='none'"></div>
                    <div class="nome-prod-box"><div class="nome-prod-texto">${item.produto}</div></div>
                    <div class="area-preco">
                        <div class="preco-wrapper">
                            <span class="rs">R$</span>
                            <span class="valor-grande">${formatarMoeda(item.preco)}</span>
                            <span class="unidade">/${item.unidade || 'un'}</span>
                        </div>
                    </div>
                </div>`;
                container.innerHTML += html;
            }
            indiceGlobal += ITENS_POR_PAGINA;
        }

        window.onload = function() {
            carregarCache();
            buscarDados();
            setInterval(function() { if(listaGlobal.length > 0) renderizar(); }, TEMPO_TROCA);
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>