<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>MGA Premium: Agenda + Vídeo</title>
<style>
    /* --- RESET & GERAL --- */
    * { box-sizing: border-box; }
    body, html {
        margin: 0; padding: 0;
        width: 100%; height: 100%;
        overflow: hidden;
        background-color: #ffffff; 
        font-family: 'Segoe UI', Helvetica, Arial, sans-serif;
    }

    /* CABEÇALHO */
    header {
        height: 14vh;
        background: #d32f2f;
        color: white;
        display: flex; align-items: center;
        padding: 0 3vw;
        box-shadow: 0 1vh 2vh rgba(0,0,0,0.2);
    }
    header h1 { font-size: 6vh; margin: 0; flex-grow: 1; text-transform: uppercase; font-weight: 800; }
    header .logo-area { font-size: 2.5vh; background: white; color: #d32f2f; padding: 1vh 2vw; border-radius: 5vh; font-weight: bold; }

    /* LAYOUT */
    #layout-principal { display: flex; width: 100%; height: 86vh; padding: 2vh 2vw; gap: 2vw; }
    
    /* ESQUERDA (LISTA) */
    #coluna-lista { width: 65%; height: 100%; display: flex; flex-direction: column; gap: 1.5vh; }
    
    .linha-produto { 
        background: #fff9c4; flex: 1; border-radius: 2vh; 
        display: flex; align-items: center; padding: 0 1.5vw; 
        box-shadow: 0 0.5vh 1vh rgba(0,0,0,0.1); border-left: 1.5vw solid #d32f2f; 
        animation: entradaSuave 0.5s ease-out; overflow: hidden;
    }
    .linha-vazia { background: transparent !important; box-shadow: none !important; border: none !important; flex: 1; }

    .midia-tabela { height: 80%; aspect-ratio: 1/1; object-fit: contain; margin-right: 1.5vw; background: #fff; border-radius: 1vh; border: 1px solid #e6e6e6; }
    .nome-tabela { flex-grow: 1; font-size: 4.5vh; color: #333; font-weight: 700; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .preco-box-tabela { text-align: right; min-width: 15vw; }
    .valor-tab { font-size: 7vh; font-weight: 800; color: #d32f2f; line-height: 1; }
    .un-tab { font-size: 2vh; color: #777; font-weight: 600; display: block; }

    /* DIREITA (DESTAQUE) */
    #coluna-destaque { width: 33%; height: 100%; }
    .card-destaque { width: 100%; height: 100%; background: #d32f2f; border-radius: 3vh; border: 0.5vh solid #ffc107; display: flex; flex-direction: column; overflow: hidden; position: relative; transition: opacity 0.5s; }
    .topo-destaque { height: 10%; background: #b71c1c; color: #ffc107; display: flex; align-items: center; justify-content: center; font-size: 3vh; font-weight: 900; text-transform: uppercase; }
    
    .area-midia-destaque { height: 50%; width: 100%; padding: 2vh; display: flex; align-items: center; justify-content: center; background: radial-gradient(circle, #e57373 0%, #d32f2f 100%); overflow: hidden; }
    
    /* CSS PARA VÍDEO E IMAGEM */
    .midia-destaque { max-width: 100%; max-height: 100%; object-fit: contain; filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.5)); }
    video.midia-destaque { width: 100%; height: 100%; object-fit: contain; }

    .info-destaque { height: 40%; background: #d32f2f; padding: 1vh 2vh; display: flex; flex-direction: column; justify-content: center; align-items: center; }
    .nome-destaque { font-size: 3.5vh; color: #ffffff; font-weight: 800; text-align: center; margin-bottom: 1vh; }
    .valor-destaque { font-size: 11vh; color: #ffffff; font-weight: 900; letter-spacing: -0.3vh; }
    
    #indicador-rede { position: fixed; bottom: 10px; right: 10px; width: 15px; height: 15px; border-radius: 50%; background: grey; z-index: 9999; border: 2px solid white; }
    @keyframes entradaSuave { from { opacity: 0; transform: translateX(-2vw); } to { opacity: 1; transform: translateX(0); } }
</style>
</head>
<body>

    <header><h1>Ofertas do Dia</h1><div class="logo-area">Confira</div></header>

    <div id="layout-principal">
        <div id="coluna-lista"></div>
        <div id="coluna-destaque">
            <div class="card-destaque" id="painel-destaque">
                <div class="topo-destaque">Super Oferta</div>
                <div class="area-midia-destaque" id="container-midia">
                    </div>
                <div class="info-destaque">
                    <div id="nome-d" class="nome-destaque">...</div>
                    <div style="display:flex;align-items:flex-start">
                        <span style="font-size:4vh;color:#ffc107;font-weight:bold;margin-top:1vh;margin-right:5px">R$</span>
                        <span id="preco-d" class="valor-destaque">...</span>
                        <span id="un-d" style="font-size:2.5vh;color:#ffc107;align-self:flex-end;margin-bottom:1.5vh"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="indicador-rede"></div>

    <script>
        var API_URL = 'https://mgaplay.com.br/ofertas/painel_ofertas.php'; 
        var ITENS_POR_LISTA = 5;      
        var TEMPO_PAGINA = 8000;
        var TEMPO_DESTAQUE = 5000; 
        
        var dadosBrutos = []; // Dados originais
        var dadosFiltrados = []; // Dados filtrados por data/hora
        var listaDestaques = [];
        
        var paginaAtual = 0;
        var indiceDestaque = 0;
        var placeholder = 'https://cdn-icons-png.flaticon.com/512/263/263142.png';
        var loopLista, loopDestaque;

        function setStatus(cor) { document.getElementById('indicador-rede').style.background = cor; }

        function formatarMoeda(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            return isNaN(v) ? valor : v.toFixed(2).replace('.', ',');
        }

        // --- LÓGICA DE AGENDAMENTO ---
        function verificarDisponibilidade(item) {
            // Se não tiver agendamento ou for "SEMPRE", exibe
            if (!item.agendamento || item.agendamento.toLowerCase() === 'sempre') return true;

            var agora = new Date();
            var hoje = agora.toISOString().split('T')[0]; // YYYY-MM-DD
            var horaAtual = agora.toTimeString().split(' ')[0].substring(0, 5); // HH:MM

            // 1. Valida Datas (Se existirem)
            if (item.data_inicio && hoje < item.data_inicio) return false;
            if (item.data_fim && hoje > item.data_fim) return false;

            // 2. Valida Horários (Se existirem)
            if (item.hora_inicio && horaAtual < item.hora_inicio) return false;
            if (item.hora_fim && horaAtual > item.hora_fim) return false;

            return true;
        }

        function atualizarFiltros() {
            // Recalcula quais itens podem ser exibidos AGORA
            dadosFiltrados = dadosBrutos.filter(verificarDisponibilidade);
            
            // Recalcula destaques baseado nos filtrados
            listaDestaques = dadosFiltrados.filter(i => i.destaque == 1 || i.destaque == true);
            if(listaDestaques.length === 0) listaDestaques = dadosFiltrados;
        }

        // --- DADOS E REDE ---
        function salvarCache(dados) { try { localStorage.setItem('mga_prem_cache', JSON.stringify(dados)); } catch(e){} }
        function carregarCache() {
            try {
                var c = localStorage.getItem('mga_prem_cache');
                if(c) {
                    var d = JSON.parse(c);
                    if(d.length > 0) { 
                        dadosBrutos = d; 
                        atualizarFiltros(); 
                        setStatus('blue'); 
                        if(!loopLista) iniciarLoops();
                        return true; 
                    }
                }
            } catch(e){}
            return false;
        }

        function buscarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            var xhr = new XMLHttpRequest();
            xhr.open("GET", API_URL + '?uid=' + uid + '&t=' + new Date().getTime(), true);
            xhr.timeout = 5000;
            xhr.onreadystatechange = function() {
                if(xhr.readyState == 4) {
                    if(xhr.status == 200) {
                        try {
                            var json = JSON.parse(xhr.responseText);
                            if(!Array.isArray(json)) json = [json];
                            
                            dadosBrutos = json;
                            salvarCache(json);
                            atualizarFiltros();
                            
                            setStatus('lime');
                            if(!loopLista) iniciarLoops();
                            
                        } catch(e) { if(dadosBrutos.length==0) carregarCache(); }
                    } else { if(dadosBrutos.length==0) carregarCache(); }
                }
            };
            xhr.send();
        }

        function iniciarLoops() {
            atualizarLista();
            loopLista = setInterval(atualizarLista, TEMPO_PAGINA);
            atualizarDestaque();
            loopDestaque = setInterval(atualizarDestaque, TEMPO_DESTAQUE);
            
            // Revalida o agendamento a cada minuto (para mudar ofertas que vencem as 18:00, por exemplo)
            setInterval(atualizarFiltros, 60000); 
        }

        // --- RENDERIZAÇÃO ---
        function atualizarLista() {
            var container = document.getElementById('coluna-lista');
            if(dadosFiltrados.length === 0) {
                container.innerHTML = '<div style="padding:2vh; text-align:center; color:#555">Sem ofertas agendadas para este horário.</div>';
                return;
            }

            var totalPags = Math.ceil(dadosFiltrados.length / ITENS_POR_LISTA);
            if(paginaAtual >= totalPags) paginaAtual = 0;
            var inicio = paginaAtual * ITENS_POR_LISTA;
            var fatia = dadosFiltrados.slice(inicio, inicio + ITENS_POR_LISTA);

            container.innerHTML = '';
            fatia.forEach(item => {
                // Lógica de Ícone (Vídeo vs Imagem na lista pequena)
                var tipo = item.tipo_midia || 'imagem';
                var icon = (tipo === 'video') ? 'https://cdn-icons-png.flaticon.com/512/2383/2383561.png' : (item.url_arquivo || item.imagem || placeholder);
                if(tipo === 'video' && (!item.url_arquivo && !item.imagem)) icon = 'https://cdn-icons-png.flaticon.com/512/2383/2383561.png'; // ícone de play

                var html = `
                    <div class="linha-produto">
                        <img src="${icon}" class="midia-tabela" onerror="this.src='${placeholder}'">
                        <div class="nome-tabela">${item.produto}</div>
                        <div class="preco-box-tabela">
                            <span class="valor-tab">R$ ${formatarMoeda(item.preco)}</span>
                            <span class="un-tab">/${item.unidade || 'un'}</span>
                        </div>
                    </div>`;
                container.innerHTML += html;
            });
            while(container.children.length < ITENS_POR_LISTA) container.innerHTML += '<div class="linha-vazia"></div>';
            paginaAtual++;
        }

        function atualizarDestaque() {
            if(listaDestaques.length === 0) return;
            var painel = document.getElementById('painel-destaque');
            
            // Fade Out
            painel.style.opacity = 0;

            setTimeout(() => {
                var index = indiceDestaque % listaDestaques.length;
                var item = listaDestaques[index];
                
                // --- LÓGICA DE VÍDEO VS IMAGEM ---
                var containerMidia = document.getElementById('container-midia');
                var midiaHtml = '';
                
                // Suporte a campo 'tipo_midia' ou detecção por extensão
                var url = item.url_arquivo || item.imagem || placeholder;
                var ehVideo = (item.tipo_midia === 'video') || (url.endsWith('.mp4') || url.endsWith('.webm'));

                if(ehVideo) {
                    // Video: Autoplay, Muted (obrigatório p/ auto), Loop
                    midiaHtml = `<video src="${url}" class="midia-destaque" autoplay muted loop playsinline></video>`;
                } else {
                    // Imagem normal
                    midiaHtml = `<img src="${url}" class="midia-destaque" onerror="this.src='${placeholder}'">`;
                }
                
                containerMidia.innerHTML = midiaHtml;
                document.getElementById('nome-d').innerText = item.produto;
                document.getElementById('preco-d').innerText = formatarMoeda(item.preco);
                document.getElementById('un-d').innerText = '/' + (item.unidade || 'un');
                
                // Fade In
                painel.style.opacity = 1;
                indiceDestaque++;
            }, 500);
        }

        window.onload = function() {
            carregarCache();
            buscarDados();
            setInterval(buscarDados, 60000);
        };
    </script>
</body>
</html>