<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Ofertas Premium (3 Itens)</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&display=swap" rel="stylesheet">
<style type="text/css">
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100%; height: 100%;
        background: radial-gradient(circle, #333 0%, #000 100%);
        font-family: 'Montserrat', 'Arial', sans-serif;
        overflow: hidden;
    }

    /* --- LOGO FLUTUANTE --- */
    .logo-tv {
        position: absolute; top: 1vh; right: 2vw; height: 12vh; width: auto; z-index: 200;
        filter: drop-shadow(0 2px 5px rgba(0,0,0,0.8)); display: none;
        background: rgba(255,255,255,0.9); padding: 5px; border-radius: 10px;
    }

    /* --- TOPO --- */
    #topo {
        position: absolute; top: 0; left: 0; width: 100%; height: 15vh;
        background-color: rgba(255,193,7, 0.1); 
        border-bottom: 0.5vh solid #ffc107;
        text-align: center; display: flex; align-items: center; justify-content: center;
        z-index: 100;
    }
    #topo h1 {
        font-family: 'Anton', 'Arial Black', sans-serif;
        font-size: 8vh; color: #ffc107; 
        text-transform: uppercase; margin: 0;
        text-shadow: 0.4vh 0.4vh 1vh #000; letter-spacing: 0.5vw;
        margin-right: 15vw; /* Espaço para Logo */
    }

    /* --- LISTA --- */
    #lista-produtos {
        position: absolute; top: 15vh; left: 0; width: 100%; height: 85vh;
        padding: 2vh 1vw; display: flex; justify-content: space-between; 
        transition: opacity 0.5s;
    }

    .cartao {
        width: 32.5%; height: 100%; 
        background: #222; border-radius: 2vh; border: 0.3vh solid #444; 
        box-shadow: 0 2vh 5vh rgba(0,0,0,0.8); overflow: hidden; display: flex; flex-direction: column;
        animation: fadeIn 0.5s ease;
    }

    .faixa-cat {
        background: #ffc107; color: #000; width: 100%; text-align: center;
        padding: 0.5vh 0; font-weight: 900; font-size: 2.5vh; text-transform: uppercase;
        flex-shrink: 0; 
    }

    .area-img {
        width: 100%; flex-grow: 1; position: relative;
        display: flex; align-items: center; justify-content: center;
        padding: 1vh; overflow: hidden;
    }
    .area-img img {
        max-height: 100%; max-width: 95%; object-fit: contain; 
        filter: drop-shadow(0 2vh 3vh rgba(0,0,0,0.6));
    }

    .nome-prod-box {
        width: 100%; min-height: 15%; 
        display: flex; align-items: center; justify-content: center;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.8)); 
        flex-shrink: 0; padding: 0 1vw;
    }
    .nome-prod-texto {
        text-align: center; font-size: 3.5vh; font-weight: 700; color: #fff; 
        text-transform: uppercase; line-height: 1.1; text-shadow: 0.3vh 0.3vh 0.5vh black;
    }

    .area-preco {
        width: 100%; height: 30%; 
        background: linear-gradient(to bottom, #2a2a2a 0%, #1a1a1a 100%);
        border-top: 0.2vh solid #444; display: flex; align-items: center; justify-content: center; flex-shrink: 0; 
    }
    
    .preco-wrapper { display: flex; align-items: flex-start; justify-content: center; line-height: 1; }
    .rs { font-size: 4vh; color: #ffc107; font-weight: bold; margin-top: 1vh; margin-right: 0.5vw; }
    .valor-grande { font-family: 'Anton', 'Arial Black', sans-serif; font-size: 14vh; color: #fff; letter-spacing: -0.5vh; }
    .unidade { font-size: 2.5vh; color: #999; font-weight: bold; align-self: flex-end; margin-bottom: 2vh; margin-left: 0.5vw; text-transform: lowercase; }

    /* VÍDEO */
    #video-container { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: black; z-index: 9999; display: none; align-items: center; justify-content: center; }
    video { width: 100%; height: 100%; object-fit: contain; }

    #status-msg { position: fixed; bottom: 50%; left: 50%; transform: translate(-50%,50%); background: rgba(0,0,0,0.8); color: white; padding: 20px; border-radius: 10px; display: none; z-index: 99999; }
    .paginacao { position: fixed; bottom: 5px; right: 5px; font-size: 2vh; color: #999; font-weight: bold; }
    @keyframes fadeIn { from { opacity: 0; transform: scale(0.95); } to { opacity: 1; transform: scale(1); } }
</style>
</head>
<body>

    <img id="img-logo-topo" class="logo-tv" src="">

    <div id="topo"><h1 id="titulo-texto">OFERTAS ESPECIAIS</h1></div>
    
    <div id="status-msg">Carregando...</div>

    <div id="lista-produtos"></div>
    <div class="paginacao" id="texto-paginacao"></div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script type="text/javascript">
        var API_URL = '../destaque-mercado.php';
        var TEMPO_TROCA = 10000;
        var ITENS_POR_PAGINA = 3; 
        var LOOPS_PARA_COMERCIAL = 3;
        var TEMPO_ATUALIZACAO = 60000; 

        var listaProdutos = [];
        var listaVideos = [];
        var idxProd = 0;
        var idxVideo = 0;
        var loops = 0;
        var timer = null;

        function formatarMoeda(valor) {
            let v = parseFloat(String(valor).replace(',', '.'));
            return isNaN(v) ? valor : v.toFixed(2).replace('.', ',');
        }

        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            fetch(API_URL + '?uid=' + uid + '&t=' + Date.now())
                .then(r => r.json())
                .then(json => {
                    var dadosItens = [];
                    // Lógica Logo
                    if (json.itens) {
                        dadosItens = json.itens;
                        var logoEl = document.getElementById('img-logo-topo');
                        if (json.meta && json.meta.logo) {
                            logoEl.src = json.meta.logo; logoEl.style.display = 'block';
                        } else { logoEl.style.display = 'none'; }
                    } else { dadosItens = Array.isArray(json) ? json : []; }

                    listaVideos = dadosItens.filter(i => i.is_video == 1 || (i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    listaProdutos = dadosItens.filter(i => i.is_video != 1 && !(i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    
                    if(listaProdutos.length === 0 && listaVideos.length === 0) {
                        document.getElementById('status-msg').style.display = 'block';
                        document.getElementById('status-msg').innerText = "Sem conteúdo.";
                    } else {
                        document.getElementById('status-msg').style.display = 'none';
                        if (!timer) rodarOfertas();
                    }
                })
                .catch(e => console.log(e));
        }

        function rodarOfertas() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('lista-produtos').style.opacity = '1';
            document.getElementById('topo').style.opacity = '1';
            document.getElementById('player').pause();

            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { rodarVideo(); return; }
                timer = setTimeout(baixarDados, 3000); return;
            }

            if (idxProd >= listaProdutos.length) {
                idxProd = 0;
                loops++;
                if (loops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    loops = 0; clearTimeout(timer); rodarVideo(); return;
                }
            }

            var container = document.getElementById('lista-produtos');
            container.innerHTML = ''; 

            for (var i = 0; i < ITENS_POR_PAGINA; i++) {
                var item = listaProdutos[(idxProd + i) % listaProdutos.length];
                
                // Evita repetir se tiver poucos produtos
                if(listaProdutos.length <= 1 && i > 0) item = null;

                if(item) {
                    var imgShow = item.imagem || 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png';
                    if(imgShow && !imgShow.includes('http') && !imgShow.startsWith('../')) imgShow = '../' + imgShow;

                    var html = `
                    <div class="cartao">
                        <div class="faixa-cat">${item.categoria || 'OFERTA'}</div>
                        <div class="area-img"><img src="${imgShow}" onerror="this.style.display='none'"></div>
                        <div class="nome-prod-box"><div class="nome-prod-texto">${item.produto}</div></div>
                        <div class="area-preco">
                            <div class="preco-wrapper">
                                <span class="rs">R$</span>
                                <span class="valor-grande">${formatarMoeda(item.preco)}</span>
                                <span class="unidade">/${item.unidade || 'un'}</span>
                            </div>
                        </div>
                    </div>`;
                    container.innerHTML += html;
                }
            }

            var pag = Math.ceil((idxProd + 1) / ITENS_POR_PAGINA);
            var tot = Math.ceil(listaProdutos.length / ITENS_POR_PAGINA);
            document.getElementById('texto-paginacao').innerText = `Pág ${pag}/${tot}`;

            idxProd += ITENS_POR_PAGINA;
            timer = setTimeout(rodarOfertas, TEMPO_TROCA);
        }

        function rodarVideo() {
            var itemVideo = listaVideos[idxVideo % listaVideos.length];
            var player = document.getElementById('player');
            
            document.getElementById('lista-produtos').style.opacity = '0';
            document.getElementById('topo').style.opacity = '0';
            document.getElementById('video-container').style.display = 'flex';
            
            var src = itemVideo.imagem;
            if(src && !src.includes('http') && !src.startsWith('../')) src = '../' + src;
            
            player.src = src;
            player.loop = false; player.currentTime = 0;
            player.muted = false; 
            player.play().catch(() => { player.muted = true; player.play(); });

            var check = setTimeout(() => { if(player.readyState < 2) encerrarComercial(); }, 8000);
            player.onended = function() { clearTimeout(check); encerrarComercial(); };
            player.onerror = function() { clearTimeout(check); encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            player.pause(); player.removeAttribute('src'); player.load(); 
            idxVideo++;
            rodarOfertas();
        }

        window.onload = function() {
            baixarDados();
            setInterval(baixarDados, TEMPO_ATUALIZACAO);
        };
    </script>
</body>
</html>